/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.annotation;

import com.alipay.sofa.boot.annotation.PlaceHolderAnnotationInvocationHandler;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.annotation.WrapperAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class AnnotationWrapper<A extends Annotation> {
    private final Class<A> clazz;
    private Annotation delegate;
    private PlaceHolderBinder binder;
    private Environment environment;

    private AnnotationWrapper(Class<A> clazz) {
        this.clazz = clazz;
    }

    public static <A extends Annotation> AnnotationWrapper<A> create(Class<A> clazz) {
        return new AnnotationWrapper<A>(clazz);
    }

    public static <A extends Annotation> AnnotationWrapper<A> create(Annotation annotation) {
        return new AnnotationWrapper(annotation.getClass());
    }

    public AnnotationWrapper<A> withBinder(PlaceHolderBinder binder) {
        this.binder = binder;
        return this;
    }

    public AnnotationWrapper<A> withEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public A wrap(A annotation) {
        Assert.notNull(annotation, (String)"annotation must not be null.");
        Assert.isInstanceOf(this.clazz, annotation, (String)"parameter must be annotation type.");
        this.delegate = annotation;
        return this.build();
    }

    private A build() {
        ClassLoader cl = this.getClass().getClassLoader();
        Class[] exposedInterface = new Class[]{this.delegate.annotationType(), WrapperAnnotation.class};
        return (A)((Annotation)Proxy.newProxyInstance(cl, exposedInterface, (InvocationHandler)new PlaceHolderAnnotationInvocationHandler(this.delegate, this.binder, this.environment)));
    }
}

