/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.annotation;

import com.alipay.sofa.boot.annotation.AnnotationWrapper;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.annotation.WrapperAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class PlaceHolderAnnotationInvocationHandler
implements InvocationHandler {
    private final Annotation delegate;
    private final PlaceHolderBinder binder;
    private final Environment environment;

    public PlaceHolderAnnotationInvocationHandler(Annotation delegate, PlaceHolderBinder binder, Environment environment) {
        this.delegate = delegate;
        this.binder = binder;
        this.environment = environment;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = method.invoke((Object)this.delegate, args);
        if (ret != null && !ReflectionUtils.isObjectMethod((Method)method) && this.isAttributeMethod(method)) {
            return this.resolvePlaceHolder(ret);
        }
        return ret;
    }

    private boolean isAttributeMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public Object resolvePlaceHolder(Object origin) {
        if (origin.getClass().isArray()) {
            int length = Array.getLength(origin);
            Object ret = Array.newInstance(origin.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(ret, i, this.resolvePlaceHolder(Array.get(origin, i)));
            }
            return ret;
        }
        return this.doResolvePlaceHolder(origin);
    }

    private Object doResolvePlaceHolder(Object origin) {
        if (origin instanceof String) {
            return this.binder.bind(this.environment, (String)origin);
        }
        if (origin instanceof Annotation && !(origin instanceof WrapperAnnotation)) {
            return AnnotationWrapper.create((Annotation)origin).withBinder(this.binder).withEnvironment(this.environment).wrap((Annotation)origin);
        }
        return origin;
    }
}

