/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.aop.framework.autoproxy;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class ExcludeBeanNameAutoProxyCreator
extends BeanNameAutoProxyCreator {
    @Nullable
    private List<String> excludeBeanNames;

    public void setExcludeBeanNames(String ... beanNames) {
        Assert.notEmpty((Object[])beanNames, (String)"'excludeBeanNames' must not be empty");
        this.excludeBeanNames = new ArrayList<String>(beanNames.length);
        for (String mappedName : beanNames) {
            this.excludeBeanNames.add(mappedName.strip());
        }
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return super.isMatch(beanName, mappedName) && !this.isExcluded(beanName);
    }

    private boolean isExcluded(String beanName) {
        if (this.excludeBeanNames != null) {
            for (String mappedName : this.excludeBeanNames) {
                if (!PatternMatchUtils.simpleMatch((String)mappedName, (String)beanName)) continue;
                return true;
            }
        }
        return false;
    }
}

