/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.compatibility;

import com.alipay.sofa.boot.compatibility.AbstractSwitchableCompatibilityVerifier;
import com.alipay.sofa.boot.compatibility.CompatibilityPredicate;
import java.util.Collection;
import org.springframework.core.env.Environment;

public abstract class AbstractJarVersionVerifier
extends AbstractSwitchableCompatibilityVerifier {
    public AbstractJarVersionVerifier(Environment environment) {
        super(environment);
    }

    @Override
    public CompatibilityPredicate compatibilityPredicate() {
        return () -> {
            Collection<CompatibilityPredicate> compatibilityPredicates = this.getJarCompatibilityPredicates();
            if (compatibilityPredicates == null) {
                return true;
            }
            return compatibilityPredicates.stream().allMatch(CompatibilityPredicate::isCompatible);
        };
    }

    @Override
    public String errorDescription() {
        return String.format("SOFABoot is not compatible with jar [%s] for current version.", this.name());
    }

    @Override
    public String action() {
        return String.format("Change [%s] to appropriate version,you can visit this doc [%s] and find an appropriate version,If you want to disable this check, just set the property [%s=false].", this.name(), this.doc(), this.enableKey);
    }

    public abstract Collection<CompatibilityPredicate> getJarCompatibilityPredicates();

    public abstract String name();

    public abstract String doc();
}

