/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.compatibility;

import com.alipay.sofa.boot.compatibility.CompatibilityVerifier;
import com.alipay.sofa.boot.compatibility.CompositeCompatibilityVerifier;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class CompatibilityVerifierApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public static final String COMPATIBILITY_VERIFIER_ENABLED = "sofa.boot.compatibility-verifier.enabled";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (!Boolean.parseBoolean(environment.getProperty(COMPATIBILITY_VERIFIER_ENABLED, "true"))) {
            Logger logger = LoggerFactory.getLogger(CompatibilityVerifierApplicationContextInitializer.class);
            logger.info("Skip SOFABoot compatibility Verifier");
            return;
        }
        CompositeCompatibilityVerifier compositeCompatibilityVerifier = new CompositeCompatibilityVerifier(this.getCompatibilityVerifierInstances((Environment)environment));
        compositeCompatibilityVerifier.verifyCompatibilities();
    }

    private List<CompatibilityVerifier> getCompatibilityVerifierInstances(Environment environment) {
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(Environment.class, (Object)environment);
        SpringFactoriesLoader springFactoriesLoader = SpringFactoriesLoader.forDefaultResourceLocation();
        List instances = springFactoriesLoader.load(CompatibilityVerifier.class, argumentResolver);
        AnnotationAwareOrderComparator.sort((List)instances);
        return instances;
    }
}

