/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.compatibility;

import java.util.Objects;
import org.springframework.util.StringUtils;

public class VerificationResult {
    private final String description;
    private final String action;

    private VerificationResult() {
        this.description = "";
        this.action = "";
    }

    private VerificationResult(String errorDescription, String action) {
        this.description = errorDescription;
        this.action = action;
    }

    public static VerificationResult compatible() {
        return new VerificationResult();
    }

    public static VerificationResult notCompatible(String errorDescription, String action) {
        return new VerificationResult(errorDescription, action);
    }

    public boolean isNotCompatible() {
        return StringUtils.hasText((String)this.description) || StringUtils.hasText((String)this.action);
    }

    public String toErrorMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("VerificationResult:");
        stringBuilder.append("\n");
        stringBuilder.append("\u2014\u2014 description: ");
        stringBuilder.append(this.description);
        stringBuilder.append("\n");
        stringBuilder.append("\u2014\u2014 action: ");
        stringBuilder.append(this.action);
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationResult)) {
            return false;
        }
        VerificationResult that = (VerificationResult)o;
        return this.description.equals(that.description) && this.action.equals(that.action);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.action);
    }
}

