/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.context;

import com.alipay.sofa.boot.context.ContextRefreshInterceptor;
import com.alipay.sofa.boot.context.SofaDefaultListableBeanFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SofaGenericApplicationContext
extends GenericApplicationContext {
    private static final Method GET_APPLICATION_EVENT_MULTICASTER_METHOD;
    private static final Field EARLY_APPLICATION_EVENTS_FIELD;
    private List<ContextRefreshInterceptor> interceptors = new ArrayList<ContextRefreshInterceptor>();
    private boolean publishEventToParent;

    public SofaGenericApplicationContext() {
        this(new SofaDefaultListableBeanFactory());
    }

    public SofaGenericApplicationContext(SofaDefaultListableBeanFactory beanFactory) {
        super((DefaultListableBeanFactory)beanFactory);
    }

    public void refresh() throws BeansException, IllegalStateException {
        if (CollectionUtils.isEmpty(this.interceptors)) {
            super.refresh();
            return;
        }
        Throwable throwable = null;
        try {
            this.applyInterceptorBeforeRefresh();
            super.refresh();
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            this.applyInterceptorAfterRefresh(throwable);
        }
    }

    protected void publishEvent(Object event, ResolvableType eventType) {
        ApplicationEvent applicationEvent;
        if (this.publishEventToParent) {
            super.publishEvent(event, eventType);
            return;
        }
        Assert.notNull((Object)event, (String)"Event must not be null");
        if (event instanceof ApplicationEvent) {
            applicationEvent = (ApplicationEvent)event;
        } else {
            applicationEvent = new PayloadApplicationEvent((Object)this, event);
            if (eventType == null) {
                eventType = ((PayloadApplicationEvent)applicationEvent).getResolvableType();
            }
        }
        Set earlyApplicationEvents = (Set)this.getFieldValueByReflect(EARLY_APPLICATION_EVENTS_FIELD, (Object)this);
        if (earlyApplicationEvents != null) {
            earlyApplicationEvents.add(applicationEvent);
        } else {
            ApplicationEventMulticaster applicationEventMulticaster = (ApplicationEventMulticaster)this.getMethodValueByReflect(GET_APPLICATION_EVENT_MULTICASTER_METHOD, (Object)this, new Object[0]);
            applicationEventMulticaster.multicastEvent(applicationEvent, eventType);
        }
    }

    protected void applyInterceptorBeforeRefresh() {
        this.interceptors.forEach(interceptor -> interceptor.beforeRefresh(this));
    }

    protected void applyInterceptorAfterRefresh(Throwable throwable) {
        this.interceptors.forEach(interceptor -> interceptor.afterRefresh(this, throwable));
    }

    public void setPublishEventToParent(boolean publishEventToParent) {
        this.publishEventToParent = publishEventToParent;
    }

    public void setInterceptors(List<ContextRefreshInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    private <T> T getFieldValueByReflect(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getMethodValueByReflect(Method method, Object obj, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            GET_APPLICATION_EVENT_MULTICASTER_METHOD = AbstractApplicationContext.class.getDeclaredMethod("getApplicationEventMulticaster", new Class[0]);
            GET_APPLICATION_EVENT_MULTICASTER_METHOD.setAccessible(true);
            EARLY_APPLICATION_EVENTS_FIELD = AbstractApplicationContext.class.getDeclaredField("earlyApplicationEvents");
            EARLY_APPLICATION_EVENTS_FIELD.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

