/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.context;

import com.alipay.sofa.boot.context.SofaDefaultListableBeanFactory;
import com.alipay.sofa.boot.context.SofaGenericApplicationContext;
import java.beans.PropertyEditor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class SofaSpringContextSupport {
    public static SofaDefaultListableBeanFactory createBeanFactory(ClassLoader beanClassLoader, Supplier<SofaDefaultListableBeanFactory> supplier) {
        SofaDefaultListableBeanFactory beanFactory = supplier.get();
        if (!(beanFactory.getAutowireCandidateResolver() instanceof QualifierAnnotationAutowireCandidateResolver)) {
            beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        }
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
        beanFactory.setBeanClassLoader(beanClassLoader);
        beanFactory.addPropertyEditorRegistrar(registry -> {
            registry.registerCustomEditor(Class.class, (PropertyEditor)new ClassEditor(beanClassLoader));
            registry.registerCustomEditor(Class[].class, (PropertyEditor)new ClassArrayEditor(beanClassLoader));
        });
        CachedIntrospectionResults.acceptClassLoader((ClassLoader)beanClassLoader);
        return beanFactory;
    }

    public static SofaGenericApplicationContext createApplicationContext(SofaDefaultListableBeanFactory beanFactory, Function<SofaDefaultListableBeanFactory, SofaGenericApplicationContext> function) {
        SofaGenericApplicationContext ctx = function.apply(beanFactory);
        ctx.setClassLoader(beanFactory.getBeanClassLoader());
        return ctx;
    }
}

