/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.context.processor;

import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.boot.context.processor.SofaPostProcessorShareFilter;
import com.alipay.sofa.boot.context.processor.UnshareSofaPostProcessor;
import com.alipay.sofa.boot.util.BeanDefinitionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class SofaPostProcessorShareManager
implements BeanFactoryAware,
InitializingBean {
    private static final String[] WHITE_NAME_LIST = new String[]{ConfigurationClassPostProcessor.class.getName() + ".importAwareProcessor", ConfigurationClassPostProcessor.class.getName() + ".importRegistry", ConfigurationClassPostProcessor.class.getName() + ".enhancedConfigurationProcessor"};
    private final Map<String, Object> registerSingletonMap = new HashMap<String, Object>();
    private final Map<String, BeanDefinition> registerBeanDefinitionMap = new HashMap<String, BeanDefinition>();
    private ConfigurableListableBeanFactory beanFactory;
    private boolean isShareParentContextPostProcessors = true;
    private List<SofaPostProcessorShareFilter> sofaPostProcessorShareFilters = new ArrayList<SofaPostProcessorShareFilter>();

    public void afterPropertiesSet() throws Exception {
        if (!this.isShareParentContextPostProcessors) {
            return;
        }
        Assert.notNull((Object)this.beanFactory, (String)"beanFactory must not be null");
        Assert.notNull(this.registerSingletonMap, (String)"registerSingletonMap must not be null");
        Assert.notNull(this.registerBeanDefinitionMap, (String)"registerBeanDefinitionMap must not be null");
        Assert.notNull(this.sofaPostProcessorShareFilters, (String)"sofaPostProcessorShareFilters must not be null");
        this.initShareSofaPostProcessors();
    }

    private void initShareSofaPostProcessors() {
        HashSet<String> beanNames = new HashSet<String>();
        HashSet<String> allBeanDefinitionNames = new HashSet<String>(Arrays.asList(this.beanFactory.getBeanDefinitionNames()));
        String[] eanFactoryPostProcessors = this.beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        String[] beanPostProcessors = this.beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        beanNames.addAll(Arrays.asList(eanFactoryPostProcessors));
        beanNames.addAll(Arrays.asList(beanPostProcessors));
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition;
            Class<?> clazz;
            if (!this.notInWhiteNameList(beanName) || !allBeanDefinitionNames.contains(beanName) || (clazz = BeanDefinitionUtil.resolveBeanClassType(beanDefinition = this.beanFactory.getBeanDefinition(beanName))) == null || !this.shouldBeanShare(beanName, clazz)) continue;
            if (this.shouldBeanSingleton(beanName, clazz)) {
                this.registerSingletonMap.put(beanName, this.beanFactory.getBean(beanName));
                continue;
            }
            this.registerBeanDefinitionMap.put(beanName, beanDefinition);
        }
    }

    private boolean shouldBeanShare(String beanName, Class<?> clazz) {
        if (AnnotationUtils.findAnnotation(clazz, UnshareSofaPostProcessor.class) != null) {
            return false;
        }
        for (SofaPostProcessorShareFilter filter : this.sofaPostProcessorShareFilters) {
            if (!filter.skipShareByBeanName(beanName) && !filter.skipShareByClass(clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldBeanSingleton(String beanName, Class<?> clazz) {
        if (AnnotationUtils.findAnnotation(clazz, SingletonSofaPostProcessor.class) != null) {
            return true;
        }
        for (SofaPostProcessorShareFilter filter : this.sofaPostProcessorShareFilters) {
            if (!filter.useSingletonByBeanName(beanName) && !filter.useSingletonByClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean notInWhiteNameList(String beanName) {
        for (String whiteName : WHITE_NAME_LIST) {
            if (!whiteName.equals(beanName)) continue;
            return false;
        }
        return true;
    }

    public boolean isShareParentContextPostProcessors() {
        return this.isShareParentContextPostProcessors;
    }

    public void setShareParentContextPostProcessors(boolean shareParentContextPostProcessors) {
        this.isShareParentContextPostProcessors = shareParentContextPostProcessors;
    }

    public List<SofaPostProcessorShareFilter> getSofaPostProcessorShareFilters() {
        return this.sofaPostProcessorShareFilters;
    }

    public void setSofaPostProcessorShareFilters(List<SofaPostProcessorShareFilter> sofaPostProcessorShareFilters) {
        this.sofaPostProcessorShareFilters = sofaPostProcessorShareFilters;
    }

    public Map<String, Object> getRegisterSingletonMap() {
        return this.registerSingletonMap;
    }

    public Map<String, BeanDefinition> getRegisterBeanDefinitionMap() {
        return this.registerBeanDefinitionMap;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"beanFactory must be ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

