/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.env;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class SofaBootEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";
    private static final List<String> SOFABOOT_EXCLUDE_AUTOCONFIGURATION_CLASSES = List.of("org.springframework.boot.actuate.autoconfigure.startup.StartupEndpointAutoConfiguration");

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().get("sofaConfigurationProperties") != null) {
            return;
        }
        this.addSofaBootDefaultPropertySource(environment);
        this.addSpringExcludeConfigurationPropertySource(environment);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    private void addSofaBootDefaultPropertySource(ConfigurableEnvironment environment) {
        Properties defaultConfiguration = this.getSofaBootVersionProperties();
        defaultConfiguration.put("management.endpoints.web.exposure.include", "info,health,readiness,startup,beans,components,rpc,isle,threadpool");
        PropertiesPropertySource propertySource = new PropertiesPropertySource("sofaConfigurationProperties", defaultConfiguration);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }

    private void addSpringExcludeConfigurationPropertySource(ConfigurableEnvironment environment) {
        Binder binder = Binder.get((Environment)environment);
        ArrayList<String> excludeConfigs = new ArrayList<String>();
        List stringList = (List)binder.bind(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, String[].class).map(List::of).orElse(new ArrayList());
        excludeConfigs.addAll(SOFABOOT_EXCLUDE_AUTOCONFIGURATION_CLASSES);
        excludeConfigs.addAll(stringList);
        Properties properties = new Properties();
        properties.put(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE, StringUtils.collectionToCommaDelimitedString(excludeConfigs));
        PropertiesPropertySource propertySource = new PropertiesPropertySource("sofaExcludeAutoConfigurationProperties", properties);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    protected Properties getSofaBootVersionProperties() {
        Properties properties = new Properties();
        String sofaBootVersion = this.getSofaBootVersion();
        sofaBootVersion = !StringUtils.hasText((String)sofaBootVersion) ? "" : sofaBootVersion;
        String sofaBootFormattedVersion = sofaBootVersion.isEmpty() ? "" : String.format(" (v%s)", sofaBootVersion);
        properties.setProperty("sofa-boot.version", sofaBootVersion);
        properties.setProperty("sofa-boot.formatted-version", sofaBootFormattedVersion);
        return properties;
    }

    protected String getSofaBootVersion() {
        return SofaBootEnvironmentPostProcessor.class.getPackage().getImplementationVersion();
    }

    public int getOrder() {
        return 2147483547;
    }
}

