/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.listener;

import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.common.config.source.AbstractConfigSource;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class SofaConfigSourceSupportListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private final AtomicBoolean registered = new AtomicBoolean();

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (this.registered.compareAndSet(false, true)) {
            this.registerSofaConfigs(event.getEnvironment());
        }
    }

    private void registerSofaConfigs(final ConfigurableEnvironment environment) {
        SofaConfigs.addConfigSource((ConfigSource)new AbstractConfigSource(){

            public int getOrder() {
                return Integer.MAX_VALUE;
            }

            public String getName() {
                return "sofa-boot";
            }

            public String doGetConfig(String key) {
                return environment.getProperty(key);
            }

            public boolean hasKey(String key) {
                return StringUtils.hasText((String)environment.getProperty(key));
            }
        });
    }

    public int getOrder() {
        return -2147483635;
    }
}

