/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.listener;

import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SwitchableApplicationListener<E extends ApplicationEvent>
implements ApplicationListener<E> {
    protected static final String CONFIG_KEY_PREFIX = "sofa.boot.switch.listener.";

    public void onApplicationEvent(E event) {
        ApplicationContext applicationContext = null;
        ConfigurableEnvironment environment = null;
        if (event instanceof ApplicationContextEvent) {
            ApplicationContextEvent applicationContextEvent = (ApplicationContextEvent)event;
            applicationContext = applicationContextEvent.getApplicationContext();
        } else if (event instanceof ApplicationContextInitializedEvent) {
            ApplicationContextInitializedEvent applicationContextInitializedEvent = (ApplicationContextInitializedEvent)event;
            applicationContext = applicationContextInitializedEvent.getApplicationContext();
        } else if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ApplicationEnvironmentPreparedEvent environmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)event;
            environment = environmentPreparedEvent.getEnvironment();
        } else if (event instanceof ApplicationPreparedEvent) {
            ApplicationPreparedEvent applicationPreparedEvent = (ApplicationPreparedEvent)event;
            applicationContext = applicationPreparedEvent.getApplicationContext();
        } else if (event instanceof ApplicationReadyEvent) {
            ApplicationReadyEvent applicationReadyEvent = (ApplicationReadyEvent)event;
            applicationContext = applicationReadyEvent.getApplicationContext();
        } else if (event instanceof ApplicationStartedEvent) {
            ApplicationStartedEvent applicationStartedEvent = (ApplicationStartedEvent)event;
            applicationContext = applicationStartedEvent.getApplicationContext();
        } else if (event instanceof ApplicationFailedEvent) {
            ApplicationFailedEvent applicationFailedEvent = (ApplicationFailedEvent)event;
            applicationContext = applicationFailedEvent.getApplicationContext();
        }
        if (environment == null && applicationContext != null) {
            environment = applicationContext.getEnvironment();
        }
        if (environment != null) {
            if (this.isEnable((Environment)environment)) {
                this.doOnApplicationEvent(event);
            }
        } else {
            this.doOnApplicationEvent(event);
        }
    }

    protected abstract void doOnApplicationEvent(E var1);

    protected abstract String switchKey();

    protected boolean matchIfMissing() {
        return true;
    }

    protected boolean isEnable(Environment environment) {
        String switchKey = this.switchKey();
        Assert.hasText((String)switchKey, (String)"switch key must has text.");
        String realKey = CONFIG_KEY_PREFIX + switchKey + ".enabled";
        String switchStr = environment.getProperty(realKey);
        if (StringUtils.hasText((String)switchStr)) {
            return Boolean.parseBoolean(switchStr);
        }
        return this.matchIfMissing();
    }
}

