/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.logging;

import com.alipay.sofa.boot.util.SofaBootEnvUtils;
import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class LogEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483637;
    public static final String SOFA_THREAD_POOL_MONITOR_DISABLE = "sofa.boot.tools.threadpool.monitor.disable";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.defaultConsoleLoggers();
        this.initLoggingConfig(environment);
        this.initSofaCommonThread(environment);
    }

    public int getOrder() {
        return -2147483637;
    }

    private void initLoggingConfig(ConfigurableEnvironment environment) {
        HashMap<String, String> context = new HashMap<String, String>();
        this.loadLogConfiguration("logging.path", environment.getProperty("logging.path"), Constants.LOGGING_PATH_DEFAULT, context);
        this.loadLogConfiguration("loggingRoot", environment.getProperty("loggingRoot"), (String)context.get("logging.path"), context);
        this.loadLogConfiguration("file.encoding", environment.getProperty("file.encoding"), context);
        LogEnvUtils.keepCompatible(context, (boolean)true);
        for (Map.Entry entry : context.entrySet()) {
            CommonLoggingConfigurations.loadExternalConfiguration((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!LogEnvUtils.isSofaCommonLoggingConfig((String)key)) continue;
                CommonLoggingConfigurations.loadExternalConfiguration((String)key, (String)environment.getProperty(key));
            }
        }
    }

    private void defaultConsoleLoggers() {
        if (SofaBootEnvUtils.isLocalEnv() || SofaBootEnvUtils.isSpringTestEnv()) {
            CommonLoggingConfigurations.loadExternalConfiguration((String)"sofa.middleware.log.console", (String)"true");
        }
    }

    private void loadLogConfiguration(String key, String value, String defaultValue, Map<String, String> context) {
        if (StringUtils.hasText((String)value)) {
            context.put(key, value);
        } else {
            context.put(key, defaultValue);
        }
    }

    private void loadLogConfiguration(String key, String value, Map<String, String> context) {
        if (StringUtils.hasText((String)value)) {
            context.put(key, value);
        }
    }

    private void initSofaCommonThread(ConfigurableEnvironment environment) {
        if (Boolean.parseBoolean(environment.getProperty(SOFA_THREAD_POOL_MONITOR_DISABLE))) {
            System.setProperty("sofa_thread_pool_logging_capability", "false");
        }
    }
}

