/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.spring.namespace.handler;

import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class SofaBootNamespaceHandler
extends NamespaceHandlerSupport {
    private static final Logger logger = SofaBootLoggerFactory.getLogger(SofaBootNamespaceHandler.class);

    public void init() {
        List sofaBootTagNameSupports = SpringFactoriesLoader.loadFactories(SofaBootTagNameSupport.class, null);
        sofaBootTagNameSupports.forEach(this::registerTagParser);
    }

    private void registerTagParser(SofaBootTagNameSupport tagNameSupport) {
        if (tagNameSupport instanceof BeanDefinitionParser) {
            this.registerBeanDefinitionParser(tagNameSupport.supportTagName(), (BeanDefinitionParser)tagNameSupport);
        } else if (tagNameSupport instanceof BeanDefinitionDecorator) {
            this.registerBeanDefinitionDecoratorForAttribute(tagNameSupport.supportTagName(), (BeanDefinitionDecorator)tagNameSupport);
        } else {
            logger.error("{} class supported [{}] parser are not instance of BeanDefinitionParser or BeanDefinitionDecorator", (Object)tagNameSupport.getClass().getName(), (Object)tagNameSupport.supportTagName());
        }
    }
}

