/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.startup;

import com.alipay.sofa.boot.startup.BaseStat;
import com.alipay.sofa.boot.startup.BeanStat;
import com.alipay.sofa.boot.startup.BeanStatCustomizer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.boot.context.metrics.buffering.StartupTimeline;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;

public class StartupReporter {
    public static final String SPRING_BEANS_INSTANTIATE = "spring.beans.instantiate";
    public static final String SPRING_BEANS_SMART_INSTANTIATE = "spring.beans.smart-initialize";
    public static final String SPRING_CONTEXT_BEANDEF_REGISTRY_POST_PROCESSOR = "spring.context.beandef-registry.post-process";
    public static final String SPRING_CONTEXT_BEAN_FACTORY_POST_PROCESSOR = "spring.context.bean-factory.post-process";
    public static final String SPRING_BEAN_POST_PROCESSOR = "spring.context.beans.post-process";
    public static final String SPRING_CONFIG_CLASSES_ENHANCE = "spring.context.config-classes.enhance";
    public static final Collection<String> SPRING_BEAN_INSTANTIATE_TYPES = Set.of("spring.beans.instantiate", "spring.beans.smart-initialize");
    public static final Collection<String> SPRING_CONTEXT_POST_PROCESSOR_TYPES = Set.of("spring.context.beandef-registry.post-process", "spring.context.bean-factory.post-process");
    public static final Collection<String> SPRING_CONFIG_CLASSES_ENHANCE_TYPES = Set.of("spring.context.config-classes.enhance", "spring.context.beans.post-process");
    private final StartupStaticsModel startupStaticsModel = new StartupStaticsModel();
    private final List<BeanStatCustomizer> beanStatCustomizers;
    private int bufferSize = 4096;
    private int costThreshold = 50;

    public StartupReporter() {
        this.startupStaticsModel.setApplicationBootTime(ManagementFactory.getRuntimeMXBean().getStartTime());
        this.beanStatCustomizers = SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)StartupReporter.class.getClassLoader()).load(BeanStatCustomizer.class);
    }

    public void bindToStartupReporter(ConfigurableEnvironment environment) {
        try {
            Binder.get((Environment)environment).bind("sofa.boot.startup", Bindable.ofInstance((Object)this));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot bind to StartupReporter", ex);
        }
    }

    public void setAppName(String appName) {
        this.startupStaticsModel.setAppName(appName);
    }

    public void applicationBootFinish() {
        this.startupStaticsModel.setApplicationBootElapsedTime(ManagementFactory.getRuntimeMXBean().getUptime());
        this.startupStaticsModel.getStageStats().sort((o1, o2) -> {
            if (o1.getStartTime() == o2.getStartTime()) {
                return 0;
            }
            return o1.getStartTime() > o2.getStartTime() ? 1 : -1;
        });
    }

    public void addCommonStartupStat(BaseStat stat) {
        this.startupStaticsModel.getStageStats().add(stat);
    }

    public BaseStat getStageNyName(String stageName) {
        return this.startupStaticsModel.getStageStats().stream().filter(commonStartupStat -> commonStartupStat.getName().equals(stageName)).findFirst().orElse(null);
    }

    public StartupStaticsModel getStartupStaticsModel() {
        return this.startupStaticsModel;
    }

    public StartupStaticsModel drainStartupStaticsModel() {
        StartupStaticsModel startupStaticsModel = new StartupStaticsModel();
        startupStaticsModel.setAppName(this.startupStaticsModel.getAppName());
        startupStaticsModel.setApplicationBootElapsedTime(this.startupStaticsModel.getApplicationBootElapsedTime());
        startupStaticsModel.setApplicationBootTime(this.startupStaticsModel.getApplicationBootTime());
        ArrayList<BaseStat> stats = new ArrayList<BaseStat>();
        Iterator<BaseStat> iterator = this.startupStaticsModel.getStageStats().iterator();
        while (iterator.hasNext()) {
            stats.add(iterator.next());
            iterator.remove();
        }
        startupStaticsModel.setStageStats(stats);
        return startupStaticsModel;
    }

    public List<BeanStat> generateBeanStats(ConfigurableApplicationContext context) {
        ArrayList<BeanStat> rootBeanStatList = new ArrayList<BeanStat>();
        ApplicationStartup applicationStartup = context.getApplicationStartup();
        if (applicationStartup instanceof BufferingApplicationStartup) {
            BufferingApplicationStartup bufferingApplicationStartup = (BufferingApplicationStartup)applicationStartup;
            HashMap beanStatIdMap = new HashMap();
            StartupTimeline startupTimeline = bufferingApplicationStartup.drainBufferedTimeline();
            List timelineEvents = startupTimeline.getEvents();
            timelineEvents.forEach(timelineEvent -> {
                BeanStat beanStat = this.eventToBeanStat((StartupTimeline.TimelineEvent)timelineEvent);
                rootBeanStatList.add(beanStat);
                beanStatIdMap.put(timelineEvent.getStartupStep().getId(), beanStat);
            });
            timelineEvents.forEach(timelineEvent -> {
                BeanStat parentBeanStat = (BeanStat)beanStatIdMap.get(timelineEvent.getStartupStep().getParentId());
                BeanStat beanStat = (BeanStat)beanStatIdMap.get(timelineEvent.getStartupStep().getId());
                if (parentBeanStat != null) {
                    parentBeanStat.setRealRefreshElapsedTime(parentBeanStat.getRealRefreshElapsedTime() - beanStat.getCost());
                    rootBeanStatList.remove(beanStat);
                    if (this.filterBeanInitializeByCost(beanStat)) {
                        parentBeanStat.addChild(beanStat);
                        this.customBeanStat(context, beanStat);
                    }
                } else if (!this.filterBeanInitializeByCost(beanStat)) {
                    rootBeanStatList.remove(beanStat);
                } else {
                    this.customBeanStat(context, beanStat);
                }
            });
        }
        return rootBeanStatList;
    }

    private boolean filterBeanInitializeByCost(BeanStat beanStat) {
        String name = beanStat.getType();
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(name) || SPRING_CONTEXT_POST_PROCESSOR_TYPES.contains(name) || SPRING_CONFIG_CLASSES_ENHANCE_TYPES.contains(name)) {
            return beanStat.getCost() >= (long)this.costThreshold;
        }
        return true;
    }

    private BeanStat eventToBeanStat(StartupTimeline.TimelineEvent timelineEvent) {
        BeanStat beanStat = new BeanStat();
        beanStat.setStartTime(timelineEvent.getStartTime().toEpochMilli());
        beanStat.setEndTime(timelineEvent.getEndTime().toEpochMilli());
        beanStat.setCost(timelineEvent.getDuration().toMillis());
        beanStat.setRealRefreshElapsedTime(beanStat.getCost());
        beanStat.setBeanRefreshStartTime(beanStat.getStartTime());
        beanStat.setBeanRefreshEndTime(beanStat.getEndTime());
        beanStat.setRefreshElapsedTime(beanStat.getCost());
        String name = timelineEvent.getStartupStep().getName();
        beanStat.setType(name);
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(name)) {
            StartupStep.Tags tags = timelineEvent.getStartupStep().getTags();
            String beanName = this.getValueFromTags(tags, "beanName");
            beanStat.setName(beanName);
        } else if (SPRING_CONTEXT_POST_PROCESSOR_TYPES.contains(name)) {
            StartupStep.Tags tags = timelineEvent.getStartupStep().getTags();
            String beanName = this.getValueFromTags(tags, "postProcessor");
            beanStat.setName(beanName);
        } else {
            beanStat.setName(name);
        }
        timelineEvent.getStartupStep().getTags().forEach(tag -> beanStat.putAttribute(tag.getKey(), tag.getValue()));
        beanStat.setBeanClassName(beanStat.getName());
        return beanStat;
    }

    private String getValueFromTags(StartupStep.Tags tags, String key) {
        for (StartupStep.Tag tag : tags) {
            if (!Objects.equals(key, tag.getKey())) continue;
            return tag.getValue();
        }
        return null;
    }

    private BeanStat customBeanStat(ConfigurableApplicationContext context, BeanStat beanStat) {
        if (!context.isActive()) {
            return beanStat;
        }
        String type = beanStat.getType();
        if (SPRING_BEAN_INSTANTIATE_TYPES.contains(type)) {
            String beanName = beanStat.getName();
            Object bean = context.getBean(beanName);
            beanStat.putAttribute("classType", AopProxyUtils.ultimateTargetClass((Object)bean).getName());
            BeanStat result = beanStat;
            for (BeanStatCustomizer customizer : this.beanStatCustomizers) {
                BeanStat current = customizer.customize(beanName, bean, result);
                if (current == null) {
                    return result;
                }
                result = current;
            }
            return result;
        }
        return beanStat;
    }

    public int getCostThreshold() {
        return this.costThreshold;
    }

    public void setCostThreshold(int costThreshold) {
        this.costThreshold = costThreshold;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public static class StartupStaticsModel {
        private String appName;
        private long applicationBootElapsedTime = 0L;
        private long applicationBootTime;
        private List<BaseStat> stageStats = new ArrayList<BaseStat>();

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public long getApplicationBootElapsedTime() {
            return this.applicationBootElapsedTime;
        }

        public void setApplicationBootElapsedTime(long applicationBootElapsedTime) {
            this.applicationBootElapsedTime = applicationBootElapsedTime;
        }

        public long getApplicationBootTime() {
            return this.applicationBootTime;
        }

        public void setApplicationBootTime(long applicationBootTime) {
            this.applicationBootTime = applicationBootTime;
        }

        public List<BaseStat> getStageStats() {
            return this.stageStats;
        }

        public void setStageStats(List<BaseStat> stageStats) {
            this.stageStats = stageStats;
        }
    }
}

