/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.startup;

import com.alipay.sofa.boot.startup.ChildrenStat;
import com.alipay.sofa.boot.startup.ModuleStat;
import com.alipay.sofa.boot.startup.StartupReporter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;

public class StartupSmartLifecycle
implements SmartLifecycle,
ApplicationContextAware {
    public static final String ROOT_MODULE_NAME = "ROOT_APPLICATION_CONTEXT";
    private final StartupReporter startupReporter;
    private ConfigurableApplicationContext applicationContext;

    public StartupSmartLifecycle(StartupReporter startupReporter) {
        this.startupReporter = startupReporter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void start() {
        ChildrenStat<ModuleStat> stat = new ChildrenStat<ModuleStat>();
        stat.setName("ApplicationContextRefreshStage");
        stat.setEndTime(System.currentTimeMillis());
        ModuleStat rootModuleStat = new ModuleStat();
        rootModuleStat.setName(ROOT_MODULE_NAME);
        rootModuleStat.setEndTime(stat.getEndTime());
        rootModuleStat.setThreadName(Thread.currentThread().getName());
        rootModuleStat.setChildren(this.startupReporter.generateBeanStats(this.applicationContext));
        stat.addChild(rootModuleStat);
        this.startupReporter.addCommonStartupStat(stat);
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }
}

