/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.startup;

import com.alipay.sofa.boot.startup.BaseStat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;

public class StartupSpringApplication
extends SpringApplication {
    private final List<BaseStat> initializerStartupStatList = new ArrayList<BaseStat>();

    public StartupSpringApplication(Class<?> ... primarySources) {
        super((Class[])primarySources);
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer initializer : this.getInitializers()) {
            Class requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            if (requiredType == null) continue;
            Assert.isInstanceOf((Class)requiredType, (Object)context, (String)"Unable to call initializer.");
            BaseStat stat = new BaseStat();
            stat.setName(initializer.getClass().getName());
            stat.setStartTime(System.currentTimeMillis());
            initializer.initialize(context);
            stat.setEndTime(System.currentTimeMillis());
            this.initializerStartupStatList.add(stat);
        }
    }

    public List<BaseStat> getInitializerStartupStatList() {
        return this.initializerStartupStatList;
    }
}

