/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.startup;

import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.startup.BaseStat;
import com.alipay.sofa.boot.startup.ChildrenStat;
import com.alipay.sofa.boot.startup.ModuleStat;
import com.alipay.sofa.boot.startup.StartupReporter;
import com.alipay.sofa.boot.startup.StartupReporterBeanPostProcessor;
import com.alipay.sofa.boot.startup.StartupSmartLifecycle;
import com.alipay.sofa.boot.startup.StartupSpringApplication;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.util.StringUtils;

public class StartupSpringApplicationRunListener
implements SpringApplicationRunListener,
Ordered {
    private final SpringApplication application;
    private final String[] args;
    private final StartupReporter startupReporter;
    private BaseStat jvmStartingStage;
    private BaseStat environmentPrepareStage;
    private ChildrenStat<BaseStat> applicationContextPrepareStage;
    private BaseStat applicationContextLoadStage;

    public StartupSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        this.application = springApplication;
        this.args = args;
        this.startupReporter = new StartupReporter();
    }

    public void starting(ConfigurableBootstrapContext bootstrapContext) {
        this.jvmStartingStage = new BaseStat();
        this.jvmStartingStage.setName("JvmStartingStage");
        this.jvmStartingStage.setStartTime(ManagementFactory.getRuntimeMXBean().getStartTime());
        this.jvmStartingStage.setEndTime(System.currentTimeMillis());
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        this.environmentPrepareStage = new BaseStat();
        this.environmentPrepareStage.setName("EnvironmentPrepareStage");
        this.environmentPrepareStage.setStartTime(this.jvmStartingStage.getEndTime());
        this.environmentPrepareStage.setEndTime(System.currentTimeMillis());
        this.startupReporter.setAppName(environment.getProperty("spring.application.name"));
        this.startupReporter.bindToStartupReporter(environment);
        bootstrapContext.register(StartupReporter.class, key -> this.startupReporter);
        ApplicationStartup userApplicationStartup = this.application.getApplicationStartup();
        if (ApplicationStartup.DEFAULT == userApplicationStartup || userApplicationStartup == null) {
            this.application.setApplicationStartup((ApplicationStartup)new BufferingApplicationStartup(this.startupReporter.getBufferSize()));
        }
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        this.applicationContextPrepareStage = new ChildrenStat();
        this.applicationContextPrepareStage.setName("ApplicationContextPrepareStage");
        this.applicationContextPrepareStage.setStartTime(this.environmentPrepareStage.getEndTime());
        this.applicationContextPrepareStage.setEndTime(System.currentTimeMillis());
        SpringApplication springApplication = this.application;
        if (springApplication instanceof StartupSpringApplication) {
            StartupSpringApplication startupSpringApplication = (StartupSpringApplication)springApplication;
            List<BaseStat> baseStatList = startupSpringApplication.getInitializerStartupStatList();
            this.applicationContextPrepareStage.setChildren(new ArrayList<BaseStat>(baseStatList));
            baseStatList.clear();
        }
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
        this.applicationContextLoadStage = new BaseStat();
        this.applicationContextLoadStage.setName("ApplicationContextLoadStage");
        this.applicationContextLoadStage.setStartTime(this.applicationContextPrepareStage.getEndTime());
        this.applicationContextLoadStage.setEndTime(System.currentTimeMillis());
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new StartupReporterBeanPostProcessor(this.startupReporter));
        context.getBeanFactory().registerSingleton("STARTUP_REPORTER_BEAN", (Object)this.startupReporter);
        StartupSmartLifecycle startupSmartLifecycle = new StartupSmartLifecycle(this.startupReporter);
        startupSmartLifecycle.setApplicationContext((ApplicationContext)context);
        context.getBeanFactory().registerSingleton("STARTUP_SMART_LIfE_CYCLE", (Object)startupSmartLifecycle);
    }

    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
        ChildrenStat applicationRefreshStage = (ChildrenStat)this.startupReporter.getStageNyName("ApplicationContextRefreshStage");
        applicationRefreshStage.setStartTime(this.applicationContextLoadStage.getEndTime());
        applicationRefreshStage.setCost(applicationRefreshStage.getEndTime() - applicationRefreshStage.getStartTime());
        ModuleStat rootModule = (ModuleStat)applicationRefreshStage.getChildren().get(0);
        rootModule.setStartTime(applicationRefreshStage.getStartTime());
        rootModule.setCost(rootModule.getEndTime() - rootModule.getStartTime());
        this.startupReporter.addCommonStartupStat(this.jvmStartingStage);
        this.startupReporter.addCommonStartupStat(this.environmentPrepareStage);
        this.startupReporter.addCommonStartupStat(this.applicationContextPrepareStage);
        this.startupReporter.addCommonStartupStat(this.applicationContextLoadStage);
        this.startupReporter.applicationBootFinish();
        SofaBootLoggerFactory.getLogger(StartupSpringApplicationRunListener.class).info(this.getStartedMessage((Environment)context.getEnvironment(), timeTaken));
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    private String getStartedMessage(Environment environment, Duration timeTakenToStartup) {
        StringBuilder message = new StringBuilder();
        message.append("Started ");
        message.append(environment.getProperty("spring.application.name"));
        String startupLogExtraInfo = environment.getProperty("startupLogExtraInfo");
        if (StringUtils.hasText((String)startupLogExtraInfo)) {
            message.append(" with extra info [");
            message.append(startupLogExtraInfo);
            message.append("]");
        }
        message.append(" in ");
        message.append((double)timeTakenToStartup.toMillis() / 1000.0);
        message.append(" seconds");
        return message.toString();
    }
}

