/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.util;

import java.util.concurrent.Callable;

public class ClassLoaderContextUtils {
    public static void runWithTemporaryContextClassloader(Runnable runnable, ClassLoader newClassloader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(newClassloader);
        try {
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public static <T> T callWithTemporaryContextClassloader(Callable<T> callable, ClassLoader newClassloader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(newClassloader);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke callable", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

