/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.util;

import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class SofaBootEnvUtils {
    public static final String CLOUD_BOOTSTRAP_CONFIGURATION_CLASS = "org.springframework.cloud.bootstrap.BootstrapConfiguration";
    public static final boolean CLOUD_BOOTSTRAP_CONFIGURATION_CLASS_EXISTS = ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.BootstrapConfiguration", null);
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    public static final String LOCAL_ENV_KEY = "sofa.boot.useLocalEnv";
    public static final String INTELLIJ_IDE_MAIN_CLASS = "com.intellij.rt.execution.application.AppMainV2";
    private static final String ARK_BIZ_CLASSLOADER_NAME = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static boolean LOCAL_ENV = false;
    private static boolean TEST_ENV = false;

    private static void initSpringTestEnv() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"loadContext".equals(stackTraceElement.getMethodName()) || !"org.springframework.boot.test.context.SpringBootContextLoader".equals(stackTraceElement.getClassName())) continue;
            TEST_ENV = true;
            break;
        }
    }

    private static void initLocalEnv() {
        if (Boolean.getBoolean(LOCAL_ENV_KEY)) {
            LOCAL_ENV = true;
            return;
        }
        try {
            Class.forName(INTELLIJ_IDE_MAIN_CLASS);
            LOCAL_ENV = true;
        }
        catch (ClassNotFoundException e) {
            LOCAL_ENV = false;
        }
    }

    public static boolean isSpringCloudBootstrapEnvironment(Environment environment) {
        if (environment != null && SofaBootEnvUtils.isSpringCloudEnvironmentEnabled(environment)) {
            return ((ConfigurableEnvironment)environment).getPropertySources().contains(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        }
        return false;
    }

    public static boolean isSpringCloudEnvironmentEnabled(Environment environment) {
        return CLOUD_BOOTSTRAP_CONFIGURATION_CLASS_EXISTS && PropertyUtils.bootstrapEnabled((Environment)environment);
    }

    public static boolean isSpringCloud() {
        return CLOUD_BOOTSTRAP_CONFIGURATION_CLASS_EXISTS;
    }

    public static boolean isSpringTestEnv() {
        return TEST_ENV;
    }

    public static boolean isLocalEnv() {
        return LOCAL_ENV;
    }

    public static boolean isArkEnv() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader != null && ARK_BIZ_CLASSLOADER_NAME.equals(contextClassLoader.getClass().getName());
    }

    static {
        SofaBootEnvUtils.initLocalEnv();
        SofaBootEnvUtils.initSpringTestEnv();
    }
}

