/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.client.aft.Regulator;
import com.alipay.sofa.rpc.client.aft.impl.TimeWindowRegulator;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.FaultToleranceSubscriber;
import com.alipay.sofa.rpc.event.ProviderInfoRemoveEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateAllEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.module.Module;

@Extension(value="fault-tolerance")
public class FaultToleranceModule
implements Module {
    private FaultToleranceSubscriber subscriber;
    private Regulator regulator = new TimeWindowRegulator();

    @Override
    public boolean needLoad() {
        return true;
    }

    @Override
    public void install() {
        this.subscriber = new FaultToleranceSubscriber();
        EventBus.register(ClientSyncReceiveEvent.class, this.subscriber);
        EventBus.register(ClientAsyncReceiveEvent.class, this.subscriber);
        EventBus.register(ProviderInfoRemoveEvent.class, this.subscriber);
        EventBus.register(ProviderInfoUpdateEvent.class, this.subscriber);
        EventBus.register(ProviderInfoUpdateAllEvent.class, this.subscriber);
        String regulatorAlias = RpcConfigs.getOrDefaultValue("aft.regulator", "timeWindow");
        this.regulator = ExtensionLoaderFactory.getExtensionLoader(Regulator.class).getExtension(regulatorAlias);
        this.regulator.init();
    }

    @Override
    public void uninstall() {
        if (this.subscriber != null) {
            EventBus.unRegister(ClientSyncReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ClientAsyncReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ProviderInfoRemoveEvent.class, this.subscriber);
            EventBus.unRegister(ProviderInfoUpdateEvent.class, this.subscriber);
            EventBus.unRegister(ProviderInfoUpdateAllEvent.class, this.subscriber);
        }
        this.regulator.destroy();
    }

    public Regulator getRegulator() {
        return this.regulator;
    }
}

