/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.triple;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.triple.stream.ResponseSerializeSofaStreamObserver;
import com.alipay.sofa.rpc.server.triple.UniqueIdInvoker;
import com.alipay.sofa.rpc.tracer.sofatracer.TracingContextKey;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.alipay.sofa.rpc.transport.SofaStreamObserver;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.List;
import triple.Request;
import triple.Response;
import triple.SofaGenericServiceTriple;

public class GenericServiceImpl
extends SofaGenericServiceTriple.GenericServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericServiceImpl.class);
    protected UniqueIdInvoker invoker;

    public GenericServiceImpl(UniqueIdInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void generic(Request request, StreamObserver<Response> responseObserver) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        SofaRequest sofaRequest = (SofaRequest)TracingContextKey.getKeySofaRequest().get(Context.current());
        String methodName = sofaRequest.getMethodName();
        Method declaredMethod = this.invoker.getDeclaredMethod(sofaRequest, request, "unary");
        if (declaredMethod == null) {
            throw new SofaRpcException(110, "Cannot find invoke method " + methodName);
        }
        try {
            ClassLoader serviceClassLoader = this.invoker.getServiceClassLoader(sofaRequest);
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            Serializer serializer = SerializerFactory.getSerializer(request.getSerializeType());
            this.setUnaryOrServerRequestParams(sofaRequest, request, serializer, declaredMethod, false);
            SofaResponse response = this.invoker.invoke(sofaRequest);
            Object ret = this.getAppResponse(declaredMethod, response);
            Response.Builder builder = Response.newBuilder();
            builder.setSerializeType(request.getSerializeType());
            builder.setType(declaredMethod.getReturnType().getName());
            builder.setData(ByteString.copyFrom((byte[])serializer.encode(ret, null).array()));
            Response build = builder.build();
            responseObserver.onNext((Object)build);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOGGER.error("Invoke " + methodName + " error:", e);
            throw new SofaRpcRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public StreamObserver<Request> genericBiStream(StreamObserver<Response> responseObserver) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        SofaRequest sofaRequest = (SofaRequest)TracingContextKey.getKeySofaRequest().get(Context.current());
        String uniqueName = this.invoker.getServiceUniqueName(sofaRequest);
        Method serviceMethod = ReflectCache.getOverloadMethodCache(uniqueName, sofaRequest.getMethodName(), new String[]{SofaStreamObserver.class.getCanonicalName()});
        if (serviceMethod == null) {
            throw new SofaRpcException(110, "Cannot find invoke method " + sofaRequest.getMethodName());
        }
        String methodName = serviceMethod.getName();
        try {
            ClassLoader serviceClassLoader = this.invoker.getServiceClassLoader(sofaRequest);
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            final ResponseSerializeSofaStreamObserver<Response> serverResponseHandler = new ResponseSerializeSofaStreamObserver<Response>(responseObserver, null);
            this.setBidirectionalStreamRequestParams(sofaRequest, serviceMethod, serverResponseHandler);
            SofaResponse sofaResponse = this.invoker.invoke(sofaRequest);
            final SofaStreamObserver clientHandler = (SofaStreamObserver)sofaResponse.getAppResponse();
            StreamObserver<Request> streamObserver = new StreamObserver<Request>(){
                private volatile Serializer serializer = null;
                private volatile String serializeType = null;
                private volatile Class<?>[] argTypes = null;

                public void onNext(Request request) {
                    this.checkInitialize(request);
                    Object message = GenericServiceImpl.this.getInvokeArgs(request, this.argTypes, this.serializer, false)[0];
                    serverResponseHandler.setSerializeType(this.serializeType);
                    clientHandler.onNext(message);
                }

                public void onError(Throwable t) {
                    clientHandler.onError(t);
                }

                public void onCompleted() {
                    clientHandler.onCompleted();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void checkInitialize(Request request) {
                    if (this.serializer == null && this.argTypes == null) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            if (this.serializer == null && this.argTypes == null) {
                                this.serializeType = request.getSerializeType();
                                this.serializer = SerializerFactory.getSerializer(request.getSerializeType());
                                this.argTypes = GenericServiceImpl.this.getArgTypes(request, false);
                            }
                        }
                    }
                }
            };
            return streamObserver;
        }
        catch (Exception e) {
            LOGGER.error("Invoke " + methodName + " error:", e);
            throw new SofaRpcRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void genericServerStream(Request request, StreamObserver<Response> responseObserver) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        SofaRequest sofaRequest = (SofaRequest)TracingContextKey.getKeySofaRequest().get(Context.current());
        Method serviceMethod = this.invoker.getDeclaredMethod(sofaRequest, request, "serverStream");
        if (serviceMethod == null) {
            throw new SofaRpcException(110, "Cannot find invoke method " + sofaRequest.getMethodName());
        }
        String methodName = serviceMethod.getName();
        try {
            ClassLoader serviceClassLoader = this.invoker.getServiceClassLoader(sofaRequest);
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            Serializer serializer = SerializerFactory.getSerializer(request.getSerializeType());
            this.setUnaryOrServerRequestParams(sofaRequest, request, serializer, serviceMethod, true);
            sofaRequest.getMethodArgs()[sofaRequest.getMethodArgs().length - 1] = new ResponseSerializeSofaStreamObserver(responseObserver, request.getSerializeType());
            this.invoker.invoke(sofaRequest);
        }
        catch (Exception e) {
            LOGGER.error("Invoke " + methodName + " error:", e);
            throw new SofaRpcRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void setUnaryOrServerRequestParams(SofaRequest sofaRequest, Request request, Serializer serializer, Method declaredMethod, boolean isServerStreamCall) {
        Class[] argTypes = this.getArgTypes(request, isServerStreamCall);
        Object[] invokeArgs = this.getInvokeArgs(request, argTypes, serializer, isServerStreamCall);
        sofaRequest.setMethod(declaredMethod);
        sofaRequest.setMethodArgs(invokeArgs);
        sofaRequest.setMethodArgSigs(ClassTypeUtils.getTypeStrs(argTypes, true));
    }

    private void setBidirectionalStreamRequestParams(SofaRequest sofaRequest, Method serviceMethod, SofaStreamObserver<Response> serverStreamPushHandler) {
        Class[] argTypes = new Class[]{SofaStreamObserver.class};
        Object[] invokeArgs = new Object[]{serverStreamPushHandler};
        sofaRequest.setMethod(serviceMethod);
        sofaRequest.setMethodArgs(invokeArgs);
        sofaRequest.setMethodArgSigs(ClassTypeUtils.getTypeStrs(argTypes, true));
    }

    private Object getAppResponse(Method method, SofaResponse response) {
        if (response.isError()) {
            throw new SofaRpcException(199, response.getErrorMsg());
        }
        Object ret = response.getAppResponse();
        if (ret instanceof Throwable) {
            throw new SofaRpcRuntimeException((Throwable)ret);
        }
        if (ret == null) {
            ret = ClassUtils.getDefaultPrimitiveValue(method.getReturnType());
        }
        return ret;
    }

    private Class[] getArgTypes(Request request, boolean addStreamHandler) {
        ProtocolStringList argTypesList = request.getArgTypesList();
        int size = addStreamHandler ? argTypesList.size() + 1 : argTypesList.size();
        Class[] argTypes = new Class[size];
        for (int i = 0; i < argTypesList.size(); ++i) {
            String typeName = (String)argTypesList.get(i);
            argTypes[i] = ClassTypeUtils.getClass(typeName);
        }
        if (addStreamHandler) {
            argTypes[size - 1] = SofaStreamObserver.class;
        }
        return argTypes;
    }

    private Object[] getInvokeArgs(Request request, Class[] argTypes, Serializer serializer, boolean addStreamHandler) {
        List<ByteString> argsList = request.getArgsList();
        int size = addStreamHandler ? argsList.size() + 1 : argsList.size();
        Object[] args = new Object[size];
        for (int i = 0; i < argsList.size(); ++i) {
            byte[] data = argsList.get(i).toByteArray();
            args[i] = serializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(data), argTypes[i], null);
        }
        return args;
    }
}

