/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.http;

import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.DefaultAuthHostnameVerifier;
import com.aliyun.auth.credentials.http.FormatType;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.X509TrustManagerImp;
import com.aliyun.core.utils.SdkAutoCloseable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CompatibleUrlConnClient
implements SdkAutoCloseable {
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String USER_AGENT = "User-Agent";
    private static final String DEFAULT_USER_AGENT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse syncInvoke(HttpRequest request) {
        InputStream content = null;
        HttpURLConnection httpConn = this.buildHttpConnection(request);
        try {
            Object dos;
            httpConn.connect();
            if (request.getHttpContent() != null) {
                dos = new DataOutputStream(httpConn.getOutputStream());
                ((FilterOutputStream)dos).write(request.getHttpContent());
                ((DataOutputStream)dos).flush();
                ((FilterOutputStream)dos).close();
            }
            content = httpConn.getInputStream();
            HttpResponse response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content, null);
            dos = response;
            return dos;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            HttpResponse response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content, e);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    throw new CredentialException(e.getMessage(), e);
                }
            }
            httpConn.disconnect();
        }
    }

    private SSLSocketFactory createSSLSocketFactory(boolean ignoreSSLCert) {
        try {
            X509TrustManagerImp compositeX509TrustManager;
            if (ignoreSSLCert) {
                compositeX509TrustManager = new X509TrustManagerImp(true);
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>(Arrays.asList(tmf.getTrustManagers()));
                ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
                for (TrustManager tm : trustManagerList) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    finalTrustManagerList.add((X509TrustManager)tm);
                }
                compositeX509TrustManager = new X509TrustManagerImp(finalTrustManagerList);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{compositeX509TrustManager}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    private HostnameVerifier createHostnameVerifier(boolean ignoreSSLCert) {
        return DefaultAuthHostnameVerifier.getInstance(ignoreSSLCert);
    }

    public void checkHttpRequest(HttpRequest request) {
        String strUrl = request.getSysUrl();
        if (null == strUrl) {
            throw new IllegalArgumentException("URL is null for HttpRequest.");
        }
        if (null == request.getSysMethod()) {
            throw new IllegalArgumentException("Method is not set for HttpRequest.");
        }
    }

    public HttpURLConnection initHttpConnection(URL url, HttpRequest request) {
        try {
            HttpURLConnection httpConn = null;
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory(false);
                HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
                httpsConn.setSSLSocketFactory(sslSocketFactory);
                HostnameVerifier hostnameVerifier = this.createHostnameVerifier(false);
                httpsConn.setHostnameVerifier(hostnameVerifier);
                httpConn = httpsConn;
            }
            if (httpConn == null) {
                httpConn = (HttpURLConnection)url.openConnection();
            }
            httpConn.setRequestMethod(request.getSysMethod().toString());
            httpConn.setInstanceFollowRedirects(false);
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setUseCaches(false);
            this.setConnectionTimeout(httpConn, request);
            httpConn.setRequestProperty(ACCEPT_ENCODING, "identity");
            httpConn.setRequestProperty(USER_AGENT, DEFAULT_USER_AGENT);
            Map<String, String> mappedHeaders = request.getSysHeaders();
            for (Map.Entry<String, String> entry : mappedHeaders.entrySet()) {
                httpConn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (request.getHttpContent() != null) {
                httpConn.setRequestProperty(CONTENT_TYPE, request.getSysHeaders().get(CONTENT_TYPE));
            }
            return httpConn;
        }
        catch (Exception e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    public void setConnectionTimeout(HttpURLConnection httpConn, HttpRequest request) {
        httpConn.setConnectTimeout(request.getSysConnectTimeout());
        httpConn.setReadTimeout(request.getSysReadTimeout());
    }

    public HttpURLConnection buildHttpConnection(HttpRequest request) {
        this.checkHttpRequest(request);
        String strUrl = request.getSysUrl();
        try {
            URL url = new URL(strUrl);
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
            HttpURLConnection httpConn = this.initHttpConnection(url, request);
            return httpConn;
        }
        catch (Exception e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    public void parseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content, Exception e) {
        try {
            if (null == content) {
                response.setResponseMessage(e.getMessage());
                return;
            }
            byte[] buff = this.readContent(content);
            response.setResponseCode(httpConn.getResponseCode());
            response.setResponseMessage(httpConn.getResponseMessage());
            Map<String, List<String>> headers = httpConn.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                if (null == key) continue;
                List<String> values = entry.getValue();
                StringBuilder builder = new StringBuilder(values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    builder.append(",");
                    builder.append(values.get(i));
                }
                response.putHeaderParameter(key, builder.toString());
            }
            String type = response.getHeaderValue(CONTENT_TYPE);
            if (null != buff && null != type) {
                response.setSysEncoding("UTF-8");
                String[] split = type.split(";");
                response.setHttpContentType(FormatType.mapAcceptToFormat(split[0].trim()));
                if (split.length > 1 && split[1].contains("=")) {
                    String[] codings = split[1].split("=");
                    response.setSysEncoding(codings[1].trim().toUpperCase());
                }
            }
            response.setHttpContent(buff, response.getSysEncoding(), response.getHttpContentType());
        }
        catch (Exception exception) {
            throw new CredentialException(exception.getMessage(), exception);
        }
    }

    public byte[] readContent(InputStream content) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try {
            int read;
            while ((read = content.read(buff)) != -1) {
                outputStream.write(buff, 0, read);
            }
        }
        catch (IOException e) {
            throw new CredentialException(e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    public void close() {
    }

    static {
        Properties sysProps = System.getProperties();
        String version = "";
        Properties props = new Properties();
        try {
            props.load(CompatibleUrlConnClient.class.getClassLoader().getResourceAsStream("core.properties"));
            version = props.getProperty("sdk.project.version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEFAULT_USER_AGENT = String.format("AlibabaCloud (%s; %s) Java/%s Credentials/%s TeaDSL/1", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), version);
    }
}

