/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Tenant;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.StsAccount;
import com.aliyun.odps.jdbc.OdpsDatabaseMetaData;
import com.aliyun.odps.jdbc.OdpsPreparedStatement;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.ConnectionResource;
import com.aliyun.odps.jdbc.utils.OdpsLogger;
import com.aliyun.odps.jdbc.utils.Utils;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorBuilder;
import com.aliyun.odps.utils.StringUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.slf4j.MDC;

public class OdpsConnection
extends WrapperAdapter
implements Connection {
    private static final AtomicLong CONNECTION_ID_GENERATOR = new AtomicLong(0L);
    private final Odps odps;
    private final TimeZone tz;
    private final Properties info;
    private final List<Statement> stmtHandles;
    private final String charset;
    private final String logviewHost;
    private boolean isClosed = false;
    protected OdpsLogger log;
    private SQLWarning warningChain = null;
    private String connectionId;
    private final Properties sqlTaskProperties = new Properties();
    private String tunnelEndpoint;
    private String majorVersion;
    private String fallbackQuota;
    private static final String MAJOR_VERSION = "odps.task.major.version";
    private static String ODPS_SETTING_PREFIX = "odps.";
    private boolean interactiveMode = false;
    private Long autoSelectLimit = null;
    private Map<String, Map<String, List<String>>> tables;
    private Long resultCountLimit = null;
    private Long resultSizeLimit = null;
    private int tunnelRetryTime;
    private Long attachTimeout;
    private boolean disableConnSetting = false;
    private boolean useProjectTimeZone = false;
    private boolean enableLimit = false;
    private boolean autoLimitFallback = false;
    private SQLExecutor executor = null;
    private String executeProject = null;
    private CatalogSchema catalogSchema = null;
    private boolean odpsNamespaceSchema = false;
    private int retryTime = -1;
    private int readTimeout = -1;
    private int connectTimeout = -1;
    private boolean enableCommandApi;
    private boolean httpsCheck;
    private Level logLevel = Level.INFO;
    private int tunnelReadTimeout = -1;
    private int tunnelConnectTimeout = -1;

    public boolean isOdpsNamespaceSchema() {
        return this.odpsNamespaceSchema;
    }

    OdpsConnection(String url, Properties info) throws SQLException {
        int connectTimeout;
        int readTimeout;
        ConnectionResource connRes = new ConnectionResource(url, info);
        String accessId = connRes.getAccessId();
        String accessKey = connRes.getAccessKey();
        String charset = connRes.getCharset();
        String project = connRes.getProject();
        String schema = connRes.getSchema();
        String endpoint = connRes.getEndpoint();
        String tunnelEndpoint = connRes.getTunnelEndpoint();
        String logviewHost = connRes.getLogview();
        String logConfFile = connRes.getLogConfFile();
        String serviceName = connRes.getInteractiveServiceName();
        String stsToken = connRes.getStsToken();
        String logLevel = connRes.getLogLevel();
        this.sqlTaskProperties.put("odps.idata.useragent", Utils.JDBCVersion + " " + Utils.SDKVersion);
        this.connectionId = Long.toString(CONNECTION_ID_GENERATOR.incrementAndGet());
        MDC.put((String)"connectionId", (String)this.connectionId);
        try {
            readTimeout = Integer.parseInt(connRes.getReadTimeout());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("read-timeout is expected to be an integer");
        }
        try {
            connectTimeout = Integer.parseInt(connRes.getConnectTimeout());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("connect-timeout is expected to be an integer");
        }
        try {
            this.tunnelReadTimeout = Integer.parseInt(connRes.getTunnelReadTimeout());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("tunnel-read-timeout is expected to be an integer");
        }
        try {
            this.tunnelConnectTimeout = Integer.parseInt(connRes.getTunnelConnectTimeout());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("tunnel-connect-timeout is expected to be an integer");
        }
        if (logLevel != null) {
            switch (logLevel = logLevel.toUpperCase()) {
                case "DEBUG": {
                    logLevel = "FINE";
                    break;
                }
                case "WARN": {
                    logLevel = "WARNING";
                    break;
                }
                case "ERROR": {
                    logLevel = "SEVERE";
                    break;
                }
                default: {
                    logLevel = "INFO";
                }
            }
            this.logLevel = Level.parse(logLevel);
        }
        this.log = new OdpsLogger(this.getClass().getName(), this.connectionId, null, logConfFile, false, connRes.isEnableOdpsLogger(), this.logLevel);
        String version = Utils.retrieveVersion("driver.version");
        this.log.info("ODPS JDBC driver, Version " + version);
        this.log.info(String.format("endpoint=%s, project=%s, schema=%s", endpoint, project, schema));
        this.log.info("JVM timezone : " + TimeZone.getDefault().getID());
        this.log.info(String.format("charset=%s, logview host=%s", charset, logviewHost));
        Object account = stsToken == null || stsToken.length() <= 0 ? new AliyunAccount(accessId, accessKey) : new StsAccount(accessId, accessKey, stsToken);
        this.log.debug("debug mode on");
        this.odps = new Odps((Account)account);
        this.odps.setEndpoint(endpoint);
        this.odps.setDefaultProject(project);
        this.odps.setCurrentSchema(schema);
        this.odps.setUserAgent("odps-jdbc-" + version);
        int retryTime = connRes.getRetryTime();
        if (retryTime > 0) {
            this.retryTime = retryTime;
            this.odps.getRestClient().setRetryTimes(this.retryTime);
        }
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
            this.odps.getRestClient().setReadTimeout(this.readTimeout);
        }
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
            this.odps.getRestClient().setConnectTimeout(this.connectTimeout);
        }
        this.info = info;
        this.charset = charset;
        this.logviewHost = logviewHost;
        this.tunnelEndpoint = tunnelEndpoint;
        this.stmtHandles = new ArrayList<Statement>();
        this.sqlTaskProperties.putAll(connRes.getSettings());
        this.tunnelRetryTime = connRes.getTunnelRetryTime();
        this.majorVersion = connRes.getMajorVersion();
        this.interactiveMode = connRes.isInteractiveMode();
        this.tables = Collections.unmodifiableMap(connRes.getTables());
        this.executeProject = connRes.getExecuteProject();
        this.autoSelectLimit = connRes.getAutoSelectLimit();
        this.resultCountLimit = connRes.getCountLimit();
        this.resultSizeLimit = connRes.getSizeLimit();
        this.attachTimeout = connRes.getAttachTimeout();
        this.disableConnSetting = connRes.isDisableConnSetting();
        this.useProjectTimeZone = connRes.isUseProjectTimeZone();
        this.enableLimit = connRes.isEnableLimit();
        this.fallbackQuota = connRes.getFallbackQuota();
        this.autoLimitFallback = connRes.isAutoLimitFallback();
        this.enableCommandApi = connRes.isEnableCommandApi();
        this.httpsCheck = connRes.isHttpsCheck();
        if (!this.httpsCheck) {
            this.odps.getRestClient().setIgnoreCerts(true);
        }
        if (null == connRes.isOdpsNamespaceSchema()) {
            try {
                Tenant tenant = this.odps.tenant();
                this.odpsNamespaceSchema = Boolean.parseBoolean(tenant.getProperty("odps.namespace.schema"));
            }
            catch (ReloadException e) {
                this.log.info("tenant doesn't exist, this project cannot support odpsNamespaceSchema.");
                this.odpsNamespaceSchema = false;
            }
        } else {
            this.odpsNamespaceSchema = connRes.isOdpsNamespaceSchema();
        }
        this.catalogSchema = new CatalogSchema(this.odps, this.odpsNamespaceSchema);
        try {
            long startTime = System.currentTimeMillis();
            String timeZoneId = "Asia/Shanghai";
            String projectTimeZoneId = this.odps.projects().get().getProperty("odps.sql.timezone");
            if (!StringUtils.isNullOrEmpty((String)projectTimeZoneId)) {
                timeZoneId = projectTimeZoneId;
            }
            this.log.info("Project timezone: " + timeZoneId);
            this.tz = TimeZone.getTimeZone(timeZoneId);
            long cost = System.currentTimeMillis() - startTime;
            this.log.info(String.format("load project meta infos time cost=%d", cost));
            this.initSQLExecutor(serviceName, connRes.getFallbackPolicy());
            String msg = "Connect to odps project %s successfully";
            this.log.info(String.format(msg, this.odps.getDefaultProject()));
        }
        catch (OdpsException e) {
            this.log.error("Connect to odps failed:" + e.getMessage());
            throw new SQLException(e);
        }
    }

    public void initSQLExecutor(String serviceName, FallbackPolicy fallbackPolicy) throws OdpsException {
        HashMap<String, String> hints = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty((String)this.majorVersion)) {
            hints.put(MAJOR_VERSION, this.majorVersion);
        }
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith(ODPS_SETTING_PREFIX)) continue;
            hints.put(key, this.info.getProperty(key));
        }
        SQLExecutorBuilder builder = new SQLExecutorBuilder();
        Odps executeOdps = this.odps;
        if (!StringUtils.isNullOrEmpty((String)this.executeProject)) {
            executeOdps = this.odps.clone();
            executeOdps.setDefaultProject(this.executeProject);
        }
        builder.odps(executeOdps).executeMode(this.interactiveMode ? ExecuteMode.INTERACTIVE : ExecuteMode.OFFLINE).properties(hints).serviceName(serviceName).fallbackPolicy(fallbackPolicy).enableReattach(true).attachTimeout(this.attachTimeout).quotaName(this.fallbackQuota).tunnelEndpoint(this.tunnelEndpoint).tunnelGetResultMaxRetryTime(this.tunnelRetryTime).taskName(OdpsStatement.getDefaultTaskName()).enableCommandApi(this.enableCommandApi).tunnelSocketTimeout(this.tunnelConnectTimeout).tunnelReadTimeout(this.tunnelReadTimeout);
        long startTime = System.currentTimeMillis();
        this.executor = builder.build();
        if (this.interactiveMode && this.executor.getInstance() != null) {
            long cost = System.currentTimeMillis() - startTime;
            this.log.info(String.format("Attach success, instanceId:%s, attach and get tunnel endpoint time cost=%d", this.executor.getInstance().getId(), cost));
        }
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql) throws SQLException {
        OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Statement with resultset type: " + resultSetType + " is not supported");
        }
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("Statement with resultset concurrency: " + resultSetConcurrency + " is not supported");
        }
        boolean isResultSetScrollable = resultSetType == 1004;
        OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql, isResultSetScrollable);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " to false is not supported!!!");
            throw new SQLFeatureNotSupportedException("disabling autocommit is not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        MDC.remove((String)"connectionId");
        if (!this.isClosed) {
            for (Statement stmt : this.stmtHandles) {
                if (stmt == null || stmt.isClosed()) continue;
                stmt.close();
            }
            if (this.runningInInteractiveMode()) {
                this.executor.close();
            }
        }
        this.isClosed = true;
        this.log.info("connection closed");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new OdpsDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
            throw new SQLFeatureNotSupportedException("enabling read-only is not supported");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.catalogSchema.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalogSchema.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsStatement createStatement() throws SQLException {
        this.checkClosed();
        OdpsStatement stmt = new OdpsStatement(this, false);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public OdpsStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean isResultSetScrollable;
        this.checkClosed();
        switch (resultSetType) {
            case 1003: {
                isResultSetScrollable = false;
                break;
            }
            case 1004: {
                isResultSetScrollable = true;
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException("only support statement with ResultSet type: TYPE_SCROLL_INSENSITIVE, ResultSet.TYPE_FORWARD_ONLY");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException("only support statement with ResultSet concurrency: CONCUR_READ_ONLY");
            }
        }
        OdpsStatement stmt = new OdpsStatement(this, isResultSetScrollable);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.info.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.info.put(name, value);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.info;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.info.getProperty(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.catalogSchema.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.catalogSchema.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    public Odps getOdps() {
        return this.odps;
    }

    public TimeZone getProjectTimeZone() {
        return this.tz;
    }

    public boolean isUseProjectTimeZone() {
        return this.useProjectTimeZone;
    }

    public void setUseProjectTimeZone(boolean useProjectTimeZone) {
        this.useProjectTimeZone = useProjectTimeZone;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the connection has already been closed");
        }
    }

    protected String getCharset() {
        return this.charset;
    }

    protected String getLogviewHost() {
        return this.logviewHost;
    }

    public Properties getSqlTaskProperties() {
        return this.sqlTaskProperties;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public SQLExecutor getExecutor() {
        return this.executor;
    }

    public boolean runningInInteractiveMode() {
        return this.interactiveMode;
    }

    Map<String, Map<String, List<String>>> getTables() {
        return this.tables;
    }

    public String getExecuteProject() {
        return this.executeProject;
    }

    public Long getAutoSelectLimit() {
        return this.autoSelectLimit;
    }

    public Long getCountLimit() {
        return this.resultCountLimit;
    }

    public Long getSizeLimit() {
        return this.resultSizeLimit;
    }

    public boolean disableConnSetting() {
        return this.disableConnSetting;
    }

    public boolean enableLimit() {
        return this.enableLimit;
    }

    public boolean isAutoLimitFallback() {
        return this.autoLimitFallback;
    }

    public void setEnableLimit(boolean enableLimit) {
        this.enableLimit = enableLimit;
    }

    public int getRetryTime() {
        if (this.retryTime <= 0) {
            return this.odps.getRestClient().getRetryTimes();
        }
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        if (retryTime <= 0) {
            throw new IllegalArgumentException("retry-times should be positive.");
        }
        this.retryTime = retryTime;
        this.odps.getRestClient().setRetryTimes(this.retryTime);
    }

    public int getReadTimeout() {
        if (this.readTimeout == -1) {
            return this.odps.getRestClient().getReadTimeout();
        }
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout <= 0) {
            throw new IllegalArgumentException("read-timeout should be positive.");
        }
        this.readTimeout = readTimeout;
        this.odps.getRestClient().setReadTimeout(this.readTimeout);
    }

    public int getConnectTimeout() {
        if (this.connectTimeout == -1) {
            return this.odps.getRestClient().getConnectTimeout();
        }
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("connect-timeout should be positive.");
        }
        this.connectTimeout = connectTimeout;
        this.odps.getRestClient().setConnectTimeout(this.connectTimeout);
    }

    public int getTunnelReadTimeout() {
        return this.tunnelReadTimeout;
    }

    public int getTunnelConnectTimeout() {
        return this.tunnelConnectTimeout;
    }

    public boolean isEnableCommandApi() {
        return this.enableCommandApi;
    }

    public boolean isHttpsCheck() {
        return this.httpsCheck;
    }

    static class CatalogSchema {
        private Odps odps;
        private boolean twoTier = true;

        CatalogSchema(Odps odps, boolean odpsNamespaceSchema) {
            this.odps = odps;
            this.twoTier = !odpsNamespaceSchema;
        }

        String getCatalog() {
            if (this.twoTier) {
                return null;
            }
            return this.odps.getDefaultProject();
        }

        String getSchema() {
            if (this.twoTier) {
                return this.odps.getDefaultProject();
            }
            return this.odps.getCurrentSchema();
        }

        void setCatalog(String catalog) {
            if (!this.twoTier) {
                this.odps.setDefaultProject(catalog);
            }
        }

        void setSchema(String schema) {
            if (this.twoTier) {
                this.odps.setDefaultProject(schema);
            } else {
                this.odps.setCurrentSchema(schema);
            }
        }
    }
}

