/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.utils.transformer.to.odps.AbstractToOdpsTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.odps.ToOdpsTransformerFactory;
import com.aliyun.odps.sqa.commandapi.utils.SqlParserUtil;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OdpsPreparedStatement
extends OdpsStatement
implements PreparedStatement {
    private final String TABLE_NAME = "((\\w+\\.)?\\w+)";
    private final String PREP_VALUES = "\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)";
    private final String SPEC_COLUMN = "(\\([^()]*\\))?";
    private final String SPEC_PARTITION = "\\((\\s*\\w+\\s*=\\s*(\\w+|'\\w+')(\\s*,\\s*\\w+\\s*=\\s*(\\w+|'\\w+')\\s*)*\\s*)\\)";
    private final String PREP_INSERT_WITH_SPEC_PARTITION = "(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+partition\\((\\s*\\w+\\s*=\\s*(\\w+|'\\w+')(\\s*,\\s*\\w+\\s*=\\s*(\\w+|'\\w+')\\s*)*\\s*)\\)\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$";
    private final String EXAMPLE = "INSERT INTO table [(c1, c2)] [partition(p1=a,p2=b,...)] VALUES (?, ?);";
    private final String PREP_INSERT_WITHOUT_SPEC_PARTITION = "(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$";
    private static final String SQL_REGEX = "(')|(--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
    private static final Pattern SQL_PATTERN = Pattern.compile("(')|(--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)", 2);
    static ThreadLocal<SimpleDateFormat> DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    static ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    static ThreadLocal<DateTimeFormatter> ZONED_DATETIME_FORMAT = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()));
    static ThreadLocal<DateTimeFormatter> ZONED_TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").withZone(ZoneId.systemDefault()));
    private final String sql;
    private boolean verified = false;
    private String tableBatchInsertTo;
    private String partitionSpec;
    private List<String> specificColumns;
    private int parametersNum;
    TableTunnel.UploadSession session;
    ArrayRecord reuseRecord;
    int blocks;
    private HashMap<Integer, Object> parameters = new HashMap();
    private List<Object[]> batchedRows = new ArrayList<Object[]>();

    OdpsPreparedStatement(OdpsConnection conn, String sql) {
        super(conn);
        this.sql = sql;
        int counter = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++counter;
        }
        this.parametersNum = counter;
        conn.log.info("create prepared statements: " + sql);
    }

    OdpsPreparedStatement(OdpsConnection conn, String sql, boolean isResultSetScrollable) {
        this(conn, sql);
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch() throws SQLException {
        Object[] arr = new Object[this.parametersNum];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.parameters.get(i + 1);
        }
        this.batchedRows.add(arr);
        this.parameters.clear();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchedRows.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int batchedSize;
        if (!this.verified) {
            boolean withSpecPartition = this.sql.matches("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+partition\\((\\s*\\w+\\s*=\\s*(\\w+|'\\w+')(\\s*,\\s*\\w+\\s*=\\s*(\\w+|'\\w+')\\s*)*\\s*)\\)\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$");
            boolean withoutSpecPartition = this.sql.matches("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$");
            if (!withoutSpecPartition && !withSpecPartition) {
                throw new SQLException("batched statement only support following syntax: INSERT INTO table [(c1, c2)] [partition(p1=a,p2=b,...)] VALUES (?, ?);");
            }
            if (withoutSpecPartition) {
                this.setSession(Pattern.compile("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$").matcher(this.sql), false);
            }
            if (withSpecPartition) {
                this.setSession(Pattern.compile("(?i)^\\s*insert\\s+into\\s+((\\w+\\.)?\\w+)\\s*(\\([^()]*\\))?\\s+partition\\((\\s*\\w+\\s*=\\s*(\\w+|'\\w+')(\\s*,\\s*\\w+\\s*=\\s*(\\w+|'\\w+')\\s*)*\\s*)\\)\\s+values\\s*\\((\\s*\\?\\s*)(,\\s*\\?\\s*)*\\)\\s*;?\\s*$").matcher(this.sql), true);
            }
        }
        if ((batchedSize = this.batchedRows.size()) == 0) {
            return new int[0];
        }
        this.getConnection().log.info(batchedSize + " records are going to be uploaded to table " + this.tableBatchInsertTo + " in batch");
        int[] updateCounts = new int[batchedSize];
        Arrays.fill(updateCounts, -1);
        long startTime = System.currentTimeMillis();
        try (TunnelRecordWriter recordWriter = (TunnelRecordWriter)this.session.openRecordWriter((long)this.blocks, true);){
            Map<String, TypeInfo> columnTypeMap = this.session.getSchema().getColumns().stream().collect(Collectors.toMap(Column::getName, Column::getTypeInfo));
            for (int i = 0; i < batchedSize; ++i) {
                Object[] row = this.batchedRows.get(i);
                for (int j = 0; j < this.specificColumns.size(); ++j) {
                    String columnName = this.specificColumns.get(j);
                    AbstractToOdpsTransformer transformer = ToOdpsTransformerFactory.getTransformer(columnTypeMap.get(columnName).getOdpsType());
                    this.reuseRecord.set(columnName, transformer.transform(row[j], this.getConnection().getCharset()));
                }
                recordWriter.write((Record)this.reuseRecord);
                updateCounts[i] = 1;
            }
            long duration = System.currentTimeMillis() - startTime;
            float megaBytesPerSec = (float)recordWriter.getTotalBytes() / 1024.0f / 1024.0f / (float)duration * 1000.0f;
            this.getConnection().log.info(String.format("It took me %d ms to insert %d records [%d], %.2f MiB/s", duration, batchedSize, this.blocks, Float.valueOf(megaBytesPerSec)));
            ++this.blocks;
        }
        catch (TunnelException | IOException e) {
            throw new SQLException(e);
        }
        this.clearBatch();
        return updateCounts;
    }

    private void setSession(Matcher matcher, boolean hasPartition) throws SQLException {
        if (matcher.find()) {
            this.tableBatchInsertTo = matcher.group(1);
            if (hasPartition) {
                this.partitionSpec = matcher.group(4);
            }
        } else {
            throw new SQLException("cannot extract table name or partition name in SQL: " + this.sql);
        }
        List specificColumns = Optional.ofNullable(matcher.group(3)).map(s -> s.substring(1, s.length() - 1)).map(s -> s.split(",")).map(s -> Arrays.stream(s).map(String::trim).collect(Collectors.toList())).orElse(null);
        if (specificColumns != null) {
            if (specificColumns.size() != this.batchedRows.get(0).length) {
                throw new SQLException("sql has specific " + specificColumns + " columns, but only prepare " + this.batchedRows.get(0).length + " values");
            }
            this.specificColumns = specificColumns;
        }
        TableTunnel tunnel = new TableTunnel(this.getConnection().getOdps());
        try {
            if (this.tableBatchInsertTo.contains(".")) {
                String[] splited = this.tableBatchInsertTo.split("\\.");
                String projectName = splited[0];
                String tableName = splited[1];
                if (hasPartition && !StringUtils.isNullOrEmpty((String)this.partitionSpec)) {
                    PartitionSpec partition;
                    Table table = this.getConnection().getOdps().tables().get(projectName, tableName);
                    if (!table.hasPartition(partition = new PartitionSpec(this.partitionSpec))) {
                        table.createPartition(partition);
                    }
                    this.session = tunnel.createUploadSession(projectName, tableName, partition);
                } else {
                    this.session = tunnel.createUploadSession(projectName, tableName);
                }
            } else {
                String defaultProject = this.getConnection().getOdps().getDefaultProject();
                if (hasPartition && !StringUtils.isNullOrEmpty((String)this.partitionSpec)) {
                    PartitionSpec partition;
                    Table table = this.getConnection().getOdps().tables().get(defaultProject, this.tableBatchInsertTo);
                    if (!table.hasPartition(partition = new PartitionSpec(this.partitionSpec))) {
                        table.createPartition(partition);
                    }
                    this.session = tunnel.createUploadSession(defaultProject, this.tableBatchInsertTo, partition);
                } else {
                    this.session = tunnel.createUploadSession(defaultProject, this.tableBatchInsertTo);
                }
            }
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
        catch (OdpsException e) {
            throw new RuntimeException(e);
        }
        this.getConnection().log.info("create upload session id=" + this.session.getId());
        this.reuseRecord = (ArrayRecord)this.session.newRecord();
        if (specificColumns == null) {
            TableSchema schema = this.session.getSchema();
            this.specificColumns = schema.getColumns().stream().map(Column::getName).collect(Collectors.toList());
        }
        this.blocks = 0;
        this.verified = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.session != null && this.blocks > 0) {
            Long[] blockList = new Long[this.blocks];
            this.getConnection().log.info("commit session: " + this.blocks + " blocks");
            for (int i = 0; i < this.blocks; ++i) {
                blockList[i] = i;
            }
            try {
                this.session.commit(blockList);
            }
            catch (TunnelException e) {
                throw new SQLException(e);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        super.close();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.updateSql(this.sql, this.parameters));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.updateSql(this.sql, this.parameters));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.addBatch();
        return this.executeBatch().length;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.getExecuteInstance() == null) {
            this.execute();
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.parameters.put(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof java.util.Date) {
            this.parameters.put(parameterIndex, x);
        } else if (x instanceof ZonedDateTime) {
            this.parameters.put(parameterIndex, x);
        } else if (x instanceof Instant) {
            this.parameters.put(parameterIndex, x);
        } else if (x instanceof Varchar) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof Char) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof Binary) {
            this.parameters.put(parameterIndex, x);
        } else {
            throw new SQLException("can not set an object of type: " + x.getClass().getName());
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameters.put(parameterIndex, null);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.parameters.put(parameterIndex, null);
            return;
        }
        this.parameters.put(parameterIndex, x.getBytes());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private String updateSql(String sql, HashMap<Integer, Object> parameters) throws SQLException {
        List indexList = SqlParserUtil.getPlaceholderIndexList((String)sql);
        if (indexList.size() == 0) {
            return sql;
        }
        if (parameters == null || parameters.size() != indexList.size()) {
            throw new SQLException("wrong number of parameters.");
        }
        StringBuilder newSql = new StringBuilder(sql);
        int pos = 0;
        int paramIndex = 1;
        for (Integer index : indexList) {
            index = index + pos;
            newSql.deleteCharAt(index);
            String str = this.convertJavaTypeToSqlString(parameters.get(paramIndex));
            newSql.insert((int)index, str);
            pos += str.length() - 1;
            ++paramIndex;
        }
        return newSql.toString();
    }

    private String convertJavaTypeToSqlString(Object x) throws SQLException {
        if (Byte.class.isInstance(x)) {
            return String.format("%sY", x.toString());
        }
        if (Short.class.isInstance(x)) {
            return String.format("%sS", x.toString());
        }
        if (Integer.class.isInstance(x)) {
            return x.toString();
        }
        if (Long.class.isInstance(x)) {
            return String.format("%sL", x.toString());
        }
        if (Float.class.isInstance(x)) {
            return String.format("%sf", x.toString());
        }
        if (Double.class.isInstance(x)) {
            return String.format("%s", x.toString());
        }
        if (BigDecimal.class.isInstance(x)) {
            return String.format("%sBD", x.toString());
        }
        if (String.class.isInstance(x)) {
            if (this.isIllegal((String)x)) {
                throw new IllegalArgumentException("");
            }
            return "'" + x + "'";
        }
        if (byte[].class.isInstance(x)) {
            try {
                String charset = this.getConnection().getCharset();
                if (charset != null) {
                    String str = new String((byte[])x, charset);
                    if (this.isIllegal(str)) {
                        throw new IllegalArgumentException("");
                    }
                    return "'" + str + "'";
                }
                throw new SQLException("charset is null");
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        }
        if (java.util.Date.class.isInstance(x)) {
            Calendar.Builder calendarBuilder = new Calendar.Builder().setCalendarType("iso8601").setLenient(true);
            Calendar calendar = calendarBuilder.build();
            if (Timestamp.class.isInstance(x)) {
                return String.format("TIMESTAMP'%s'", x);
            }
            if (Date.class.isInstance(x)) {
                DATE_FORMAT.get().setCalendar(calendar);
                return String.format("DATE'%s'", DATE_FORMAT.get().format(x));
            }
            if (Time.class.isInstance(x)) {
                DATETIME_FORMAT.get().setCalendar(calendar);
                return String.format("DATETIME'%s'", DATETIME_FORMAT.get().format(x));
            }
            DATE_FORMAT.get().setCalendar(calendar);
            return String.format("DATE'%s'", DATE_FORMAT.get().format(x));
        }
        if (x instanceof ZonedDateTime) {
            return String.format("DATETIME'%s'", ZONED_DATETIME_FORMAT.get().format((ZonedDateTime)x));
        }
        if (x instanceof Instant) {
            return String.format("TIMESTAMP'%s'", ZONED_TIMESTAMP_FORMAT.get().format((Instant)x));
        }
        if (Boolean.class.isInstance(x)) {
            return x.toString().toUpperCase();
        }
        if (x == null || x.equals(0)) {
            return "NULL";
        }
        if (Binary.class.isInstance(x)) {
            return String.format("unhex('%s')", x);
        }
        if (Varchar.class.isInstance(x)) {
            if (this.isIllegal(x.toString())) {
                throw new IllegalArgumentException("");
            }
            return "'" + x.toString() + "'";
        }
        if (Char.class.isInstance(x)) {
            if (this.isIllegal(x.toString())) {
                throw new IllegalArgumentException("");
            }
            return "'" + x.toString() + "'";
        }
        throw new SQLException("unrecognized Java class: " + x.getClass().getName());
    }

    private boolean isIllegal(String str) {
        Matcher matcher = SQL_PATTERN.matcher(str);
        return matcher.find();
    }
}

