/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public class ConnectionResource {
    private static final String JDBC_ODPS_URL_PREFIX = "jdbc:odps:";
    private static final String CHARSET_DEFAULT_VALUE = "UTF-8";
    private static final String LIFECYCLE_DEFAULT_VALUE = "3";
    private static final String MAJOR_VERSION_DEFAULT_VALUE = "default";
    private static final String INTERACTIVE_SERVICE_NAME_DEFAULT_VALUE = "public.default";
    private static final String READ_TIMEOUT_DEFAULT_VALUE = "-1";
    private static final String CONNECT_TIMEOUT_DEFAULT_VALUE = "-1";
    private static final String ODPS_CONF_URL_KEY = "odps_config";
    private static final String ACCESS_ID_URL_KEY = "accessId";
    private static final String ACCESS_KEY_URL_KEY = "accessKey";
    private static final String PROJECT_URL_KEY = "project";
    private static final String EXECUTE_PROJECT_URL_KEY = "executeProject";
    private static final String CHARSET_URL_KEY = "charset";
    private static final String LOGVIEW_URL_KEY = "logview";
    private static final String TUNNEL_ENDPOINT_URL_KEY = "tunnelEndpoint";
    private static final String TUNNEL_RESULT_RETRY_TIME_URL_KEY = "tunnelRetryTime";
    private static final String LOG_CONF_FILE_URL_KEY = "logConfFile";
    private static final String INTERACTIVE_MODE_URL_KEY = "interactiveMode";
    private static final String SERVICE_NAME_URL_KEY = "interactiveServiceName";
    private static final String MAJOR_VERSION_URL_KEY = "majorVersion";
    private static final String ENABLE_ODPS_LOGGER_URL_KEY = "enableOdpsLogger";
    private static final String TABLE_LIST_URL_KEY = "tableList";
    private static final String FALLBACK_FOR_UNKNOWN_URL_KEY = "fallbackForUnknownError";
    private static final String FALLBACK_FOR_RESOURCE_URL_KEY = "fallbackForResourceNotEnough";
    private static final String FALLBACK_FOR_UPGRADING_URL_KEY = "fallbackForUpgrading";
    private static final String FALLBACK_FOR_TIMEOUT_URL_KEY = "fallbackForRunningTimeout";
    private static final String FALLBACK_FOR_UNSUPPORTED_URL_KEY = "fallbackForUnsupportedFeature";
    private static final String ALWAYS_FALLBACK_URL_KEY = "alwaysFallback";
    private static final String DISABLE_FALLBACK_URL_KEY = "disableFallback";
    private static final String FALLBACK_QUOTA_URL_KEY = "fallbackQuota";
    private static final String ATTACH_TIMEOUT_URL_KEY = "attachTimeout";
    private static final String AUTO_SELECT_LIMIT_URL_KEY = "autoSelectLimit";
    private static final String INSTANCE_TUNNEL_MAX_RECORD_URL_KEY = "instanceTunnelMaxRecord";
    private static final String INSTANCE_TUNNEL_MAX_SIZE_URL_KEY = "instanceTunnelMaxSize";
    private static final String STS_TOKEN_URL_KEY = "stsToken";
    private static final String DISABLE_CONN_SETTING_URL_KEY = "disableConnectionSetting";
    private static final String USE_PROJECT_TIME_ZONE_URL_KEY = "useProjectTimeZone";
    private static final String ENABLE_LIMIT_URL_KEY = "enableLimit";
    private static final String AUTO_LIMIT_FALLBACK_URL_KEY = "autoLimitFallback";
    private static final String SETTINGS_URL_KEY = "settings";
    private static final String ODPS_NAMESPACE_SCHEMA_URL_KEY = "odpsNamespaceSchema";
    private static final String SCHEMA_URL_KEY = "schema";
    private static final String READ_TIMEOUT_URL_KEY = "readTimeout";
    private static final String CONNECT_TIMEOUT_URL_KRY = "connectTimeout";
    private static final String ENABLE_COMMAND_API_URL_KEY = "enableCommandApi";
    private static final String HTTPS_CHECK_URL_KEY = "httpsCheck";
    private static final String LOG_LEVEL_URL_KEY = "logLevel";
    private static final String TUNNEL_READ_TIMEOUT_URL_KEY = "tunnelReadTimeout";
    private static final String TUNNEL_CONNECT_TIMEOUT_URL_KRY = "tunnelConnectTimeout";
    private static final String RETRY_TIME_URL_KEY = "retryTime";
    public static final String ACCESS_ID_PROP_KEY = "access_id";
    public static final String ACCESS_KEY_PROP_KEY = "access_key";
    public static final String PROJECT_PROP_KEY = "project_name";
    public static final String EXECUTE_PROJECT_PROP_KEY = "execute_project_name";
    public static final String CHARSET_PROP_KEY = "charset";
    public static final String LOGVIEW_HOST_PROP_KEY = "logview_host";
    public static final String TUNNEL_ENDPOINT_PROP_KEY = "tunnel_endpoint";
    public static final String TUNNEL_RESULT_RETRY_TIME_PROP_KEY = "tunnel_retry_time";
    public static final String LOG_CONF_FILE_PROP_KEY = "log_conf_file";
    public static final String INTERACTIVE_MODE_PROP_KEY = "interactive_mode";
    public static final String SERVICE_NAME_PROP_KEY = "interactive_service_name";
    public static final String MAJOR_VERSION_PROP_KEY = "major_version";
    public static final String ENABLE_ODPS_LOGGER_PROP_KEY = "enable_odps_logger";
    public static final String TABLE_LIST_PROP_KEY = "table_list";
    private static final String FALLBACK_FOR_UNKNOWN_PROP_KEY = "fallback_for_unknownerror";
    private static final String FALLBACK_FOR_RESOURCE_PROP_KEY = "fallback_for_resourcenotenough";
    private static final String FALLBACK_FOR_UPGRADING_PROP_KEY = "fallback_for_upgrading";
    private static final String FALLBACK_FOR_TIMEOUT_PROP_KEY = "fallback_for_runningtimeout";
    private static final String FALLBACK_FOR_UNSUPPORTED_PROP_KEY = "fallback_for_unsupportedfeature";
    private static final String ALWAYS_FALLBACK_PROP_KEY = "always_fallback";
    private static final String DISABLE_FALLBACK_PROP_KEY = "disable_fallback";
    private static final String FALLBACK_QUOTA_PROP_KEY = "fallback_quota";
    private static final String ATTACH_TIMEOUT_PROP_KEY = "attach_timeout";
    private static final String AUTO_SELECT_LIMIT_PROP_KEY = "auto_select_limit";
    private static final String INSTANCE_TUNNEL_MAX_RECORD_PROP_KEY = "instance_tunnel_max_record";
    private static final String INSTANCE_TUNNEL_MAX_SIZE_PROP_KEY = "instance_tunnel_max_size";
    private static final String STS_TOKEN_PROP_KEY = "sts_token";
    private static final String DISABLE_CONN_SETTING_PROP_KEY = "disable_connection_setting";
    private static final String USE_PROJECT_TIME_ZONE_PROP_KEY = "use_project_time_zone";
    private static final String ENABLE_LIMIT_PROP_KEY = "enable_limit";
    private static final String AUTO_FALLBACK_PROP_KEY = "auto_limit_fallback";
    private static final String SETTINGS_PROP_KEY = "settings";
    private static final String ACCESS_ID_PROP_KEY_ALT = "user";
    private static final String ACCESS_KEY_PROP_KEY_ALT = "password";
    private static final String ODPS_NAMESPACE_SCHEMA_PROP_KEY = "odps_namespace_schema";
    private static final String SCHEMA_PROP_KEY = "schema";
    private static final String READ_TIMEOUT_PROP_KEY = "read_timeout";
    private static final String CONNECT_TIMEOUT_PROP_KEY = "connect_timeout";
    private static final String ENABLE_COMMAND_API_PROP_KEY = "enable_command_api";
    private static final String HTTPS_CHECK_PROP_KEY = "https_check";
    private static final String LOG_LEVEL_PROP_KEY = "log_level";
    private static final String TUNNEL_READ_TIMEOUT_PROP_KEY = "tunnel_read_timeout";
    private static final String TUNNEL_CONNECT_TIMEOUT_PROP_KEY = "tunnel_connect_timeout";
    private static final String RETRY_TIME_PROP_KEY = "retry_time";
    private String endpoint;
    private String accessId;
    private String accessKey;
    private String project;
    private String executeProject;
    private String charset;
    private String logview;
    private String tunnelEndpoint;
    private String logConfFile;
    private boolean interactiveMode;
    private String interactiveServiceName;
    private String majorVersion;
    private String fallbackQuota;
    private boolean enableOdpsLogger = false;
    private Map<String, Map<String, List<String>>> tables = new HashMap<String, Map<String, List<String>>>();
    private FallbackPolicy fallbackPolicy = FallbackPolicy.alwaysFallbackPolicy();
    private Long autoSelectLimit;
    private Long countLimit;
    private Long sizeLimit;
    private Long attachTimeout;
    private int tunnelRetryTime;
    private String stsToken;
    private boolean disableConnSetting = false;
    private boolean useProjectTimeZone = false;
    private boolean enableLimit = false;
    private boolean autoLimitFallback = false;
    private boolean enableCommandApi = false;
    private boolean httpsCheck = false;
    private Boolean odpsNamespaceSchema = null;
    private String schema;
    private Map<String, String> settings = new HashMap<String, String>();
    private String readTimeout;
    private String connectTimeout;
    private String logLevel;
    private String tunnelReadTimeout;
    private String tunnelConnectTimeout;
    private int retryTime;

    public Boolean isOdpsNamespaceSchema() {
        return this.odpsNamespaceSchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public static boolean acceptURL(String url) {
        return url != null && url.startsWith(JDBC_ODPS_URL_PREFIX);
    }

    public ConnectionResource(String url, Properties info) {
        Map<String, String> paramsInURL = this.extractParamsFromUrl(url);
        this.init(info, paramsInURL);
    }

    /*
     * Unable to fully structure code
     */
    void init(Properties info, Map<String, String> paramsInURL) {
        maps = new ArrayList<Map>();
        if (paramsInURL.get("odps_config") != null) {
            try {
                inputStream = new FileInputStream(paramsInURL.get("odps_config"));
                if (inputStream == null) ** GOTO lbl17
                props = new Properties();
                props.load(inputStream);
                maps.add(props);
            }
            catch (IOException e) {
                throw new RuntimeException("Load odps conf failed:", e);
            }
        } else {
            maps.add(info);
            maps.add(paramsInURL);
        }
lbl17:
        // 3 sources

        this.accessId = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"user", "access_id", "accessId"});
        this.accessKey = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"password", "access_key", "accessKey"});
        if (this.accessKey != null) {
            try {
                this.accessKey = URLDecoder.decode(this.accessKey, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.accessKey = URLDecoder.decode(this.accessKey);
            }
        }
        this.charset = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "UTF-8", new String[]{"charset", "charset"});
        this.project = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"project_name", "project"});
        this.executeProject = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"execute_project_name", "executeProject"});
        this.logview = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"logview_host", "logview"});
        this.tunnelEndpoint = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"tunnel_endpoint", "tunnelEndpoint"});
        this.tunnelRetryTime = Integer.parseInt(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "6", new String[]{"tunnel_retry_time", "tunnelRetryTime"}));
        this.logConfFile = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"log_conf_file", "logConfFile"});
        this.interactiveMode = Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"interactive_mode", "interactiveMode"}));
        this.interactiveServiceName = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "public.default", new String[]{"interactive_service_name", "interactiveServiceName"});
        this.majorVersion = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"major_version", "majorVersion"});
        this.enableOdpsLogger = Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"enable_odps_logger", "enableOdpsLogger"}));
        this.fallbackPolicy.fallback4ResourceNotEnough(Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"fallback_for_resourcenotenough", "fallbackForResourceNotEnough"})).booleanValue());
        this.fallbackPolicy.fallback4RunningTimeout(Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"fallback_for_runningtimeout", "fallbackForRunningTimeout"})).booleanValue());
        this.fallbackPolicy.fallback4Upgrading(Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"fallback_for_upgrading", "fallbackForUpgrading"})).booleanValue());
        this.fallbackPolicy.fallback4UnsupportedFeature(Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"fallback_for_unsupportedfeature", "fallbackForUnsupportedFeature"})).booleanValue());
        this.fallbackPolicy.fallback4UnknownError(Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"fallback_for_unknownerror", "fallbackForUnknownError"})).booleanValue());
        alwaysFallback = Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"always_fallback", "alwaysFallback"}));
        if (alwaysFallback) {
            this.fallbackPolicy = FallbackPolicy.alwaysFallbackPolicy();
        }
        if (disableFallback = Boolean.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"disable_fallback", "disableFallback"})).booleanValue()) {
            this.fallbackPolicy = FallbackPolicy.nonFallbackPolicy();
        }
        this.fallbackQuota = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"fallback_quota", "fallbackQuota"});
        this.stsToken = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"sts_token", "stsToken"});
        this.autoSelectLimit = Long.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"auto_select_limit", "autoSelectLimit"}));
        this.countLimit = Long.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"instance_tunnel_max_record", "instanceTunnelMaxRecord"}));
        if (this.countLimit <= 0L) {
            this.countLimit = null;
        }
        this.sizeLimit = Long.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"instance_tunnel_max_size", "instanceTunnelMaxSize"}));
        if (this.sizeLimit <= 0L) {
            this.sizeLimit = null;
        }
        this.attachTimeout = Long.valueOf(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"attach_timeout", "attachTimeout"}));
        if (this.attachTimeout <= 0L) {
            this.attachTimeout = null;
        }
        this.disableConnSetting = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"disable_connection_setting", "disableConnectionSetting"}));
        this.useProjectTimeZone = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"use_project_time_zone", "useProjectTimeZone"}));
        this.enableLimit = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "true", new String[]{"enable_limit", "enableLimit"}));
        this.readTimeout = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"read_timeout", "readTimeout"});
        this.connectTimeout = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"connect_timeout", "connectTimeout"});
        this.tunnelReadTimeout = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"tunnel_read_timeout", "tunnelReadTimeout"});
        this.tunnelConnectTimeout = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"tunnel_connect_timeout", "tunnelConnectTimeout"});
        if (this.autoSelectLimit > 0L) {
            this.enableLimit = false;
        }
        this.autoLimitFallback = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"auto_limit_fallback", "autoLimitFallback"}));
        this.enableCommandApi = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"enable_command_api", "enableCommandApi"}));
        this.httpsCheck = Boolean.parseBoolean(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "false", new String[]{"https_check", "httpsCheck"}));
        this.retryTime = Integer.parseInt(ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, "-1", new String[]{"retry_time", "retryTime"}));
        this.logLevel = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"log_level", "logLevel"});
        odpsNamespaceSchemaStr = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"odps_namespace_schema", "odpsNamespaceSchema"});
        this.checkValueIsValidBoolean("odpsNamespaceSchema", odpsNamespaceSchemaStr);
        if (odpsNamespaceSchemaStr != null) {
            this.odpsNamespaceSchema = Boolean.parseBoolean(odpsNamespaceSchemaStr);
            this.settings.put("odps.namespace.schema", odpsNamespaceSchemaStr);
        }
        this.schema = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"schema", "schema"});
        if (this.schema != null) {
            if (this.odpsNamespaceSchema == null) {
                this.odpsNamespaceSchema = true;
                this.settings.put("odps.namespace.schema", "true");
            } else if (!this.odpsNamespaceSchema.booleanValue()) {
                throw new RuntimeException("ERROR: connection config invalid: schema can not be set when odpsNamespaceSchema=false");
            }
            this.settings.put("odps.default.schema", this.schema);
        }
        tablesStr = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"table_list", "tableList"});
        reusedParts = new String[3];
        if (!StringUtils.isNullOrEmpty((String)tablesStr)) {
            for (String tableStr : tablesStr.split(",")) {
                parts = tableStr.split("\\.");
                if (parts.length == 2) {
                    reusedParts[0] = parts[0];
                    reusedParts[1] = null;
                    reusedParts[2] = parts[1];
                } else if (parts.length == 3) {
                    reusedParts = parts;
                } else {
                    throw new IllegalArgumentException("Invalid table name: " + tableStr);
                }
                this.tables.computeIfAbsent(reusedParts[0], (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)());
                this.tables.get(reusedParts[0]).computeIfAbsent(reusedParts[1], (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$1(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                this.tables.get(reusedParts[0]).get(reusedParts[1]).add(reusedParts[2]);
            }
        }
        if ((globalSettingsInJson = ConnectionResource.tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, new String[]{"settings", "settings"})) != null) {
            type = new TypeToken<Map<String, String>>(){}.getType();
            this.settings.putAll((Map)GsonObjectBuilder.get().fromJson(globalSettingsInJson, type));
        }
    }

    private Map<String, String> extractParamsFromUrl(String url) {
        HashMap<String, String> paramsInURL = new HashMap<String, String>();
        int atPos = (url = url.substring(JDBC_ODPS_URL_PREFIX.length())).indexOf("?");
        if (atPos == -1) {
            this.endpoint = url;
        } else {
            String[] pairs;
            this.endpoint = url.substring(0, atPos);
            String query = url.substring(atPos + 1);
            for (String pair : pairs = query.split("&")) {
                int pos = pair.indexOf("=");
                if (pos > 0) {
                    paramsInURL.put(URLDecoder.decode(pair.substring(0, pos)), URLDecoder.decode(pair.substring(pos + 1)));
                    continue;
                }
                paramsInURL.put(URLDecoder.decode(pair), null);
            }
        }
        return paramsInURL;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getProject() {
        return this.project;
    }

    public String getExecuteProject() {
        return this.executeProject;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLogview() {
        return this.logview;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public int getTunnelRetryTime() {
        return this.tunnelRetryTime;
    }

    public String getLogConfFile() {
        return this.logConfFile;
    }

    public String getInteractiveServiceName() {
        return this.interactiveServiceName;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getFallbackQuota() {
        return this.fallbackQuota;
    }

    public boolean isEnableOdpsLogger() {
        return this.enableOdpsLogger;
    }

    public Long getAutoSelectLimit() {
        return this.autoSelectLimit;
    }

    public Long getCountLimit() {
        return this.countLimit;
    }

    public Long getSizeLimit() {
        return this.sizeLimit;
    }

    public Long getAttachTimeout() {
        return this.attachTimeout;
    }

    private static String tryGetFirstNonNullValueByAltMapAndAltKey(List<Map> maps, String defaultValue, String ... altKeys) {
        String value = null;
        for (Map map : maps) {
            if (map == null) continue;
            for (String key : altKeys) {
                value = (String)map.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return defaultValue;
    }

    private void checkValueIsValidBoolean(String key, String value) {
        if (null == value) {
            return;
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return;
        }
        throw new IllegalArgumentException("key " + key + " value should be true/false. current value " + value + " is not valid");
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Map<String, Map<String, List<String>>> getTables() {
        return this.tables;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public String getStsToken() {
        return this.stsToken;
    }

    public boolean isDisableConnSetting() {
        return this.disableConnSetting;
    }

    public boolean isUseProjectTimeZone() {
        return this.useProjectTimeZone;
    }

    public boolean isEnableLimit() {
        return this.enableLimit;
    }

    public boolean isAutoLimitFallback() {
        return this.autoLimitFallback;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getReadTimeout() {
        return this.readTimeout;
    }

    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isEnableCommandApi() {
        return this.enableCommandApi;
    }

    public boolean isHttpsCheck() {
        return this.httpsCheck;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getTunnelReadTimeout() {
        return this.tunnelReadTimeout;
    }

    public String getTunnelConnectTimeout() {
        return this.tunnelConnectTimeout;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    private static /* synthetic */ List lambda$init$1(String p) {
        return new LinkedList();
    }

    private static /* synthetic */ Map lambda$init$0(String p) {
        return new HashMap();
    }
}

