/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.AuthUtils;
import com.alicloud.openservices.tablestore.core.auth.CalculateV4SigningKeyUtil;
import com.alicloud.openservices.tablestore.core.auth.InvalidCredentialsException;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentialsV4;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.core.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class V4Credentials
implements ServiceCredentialsV4 {
    private static final ThreadLocal<DateFormat> DATA_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };
    private final String accessKeyId;
    private final String v4SigningStsToken;
    private final String region;
    private String accessKeySecret;
    private String v4SigningAccessKey;
    private String signingDate;
    private boolean autoUpdateV4SigningAccessKey = false;

    public V4Credentials(String accessKeyId, String v4SigningAccessKey, String region, String signingDate) {
        this(accessKeyId, v4SigningAccessKey, null, region, signingDate);
    }

    public V4Credentials(String accessKeyId, String v4SigningAccessKey, String v4SigningStsToken, String region, String signingDate) {
        Preconditions.checkArgument(AuthUtils.checkAccessKeyIdFormat(accessKeyId), "The access key id is not in valid format: " + accessKeyId);
        if (StringUtils.isNullOrEmpty(accessKeyId)) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (StringUtils.isNullOrEmpty(v4SigningAccessKey)) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
        if (StringUtils.isNullOrEmpty(region)) {
            throw new InvalidCredentialsException("Region for v4 signing key should not be null or empty.");
        }
        if (StringUtils.isNullOrEmpty(signingDate)) {
            throw new InvalidCredentialsException("SigningDate for v4 signing key should not be null or empty.");
        }
        this.accessKeyId = accessKeyId;
        this.v4SigningAccessKey = v4SigningAccessKey;
        this.v4SigningStsToken = v4SigningStsToken;
        this.region = region;
        this.signingDate = signingDate;
    }

    public static V4Credentials createByServiceCredentials(ServiceCredentials serviceCredentials, String region) {
        String signDate = DATA_FORMAT.get().format(new Date());
        String v4SigningAccessKey = CalculateV4SigningKeyUtil.finalSigningKeyString(serviceCredentials.getAccessKeySecret(), signDate, region, "ots", "HmacSHA256");
        V4Credentials v4Credentials = new V4Credentials(serviceCredentials.getAccessKeyId(), v4SigningAccessKey, serviceCredentials.getSecurityToken(), region, signDate);
        v4Credentials.accessKeySecret = serviceCredentials.getAccessKeySecret();
        v4Credentials.autoUpdateV4SigningAccessKey = true;
        return v4Credentials;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        this.updateV4Signature();
        return this.v4SigningAccessKey;
    }

    @Override
    public String getSecurityToken() {
        return this.v4SigningStsToken;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getSigningDate() {
        return this.signingDate;
    }

    private void updateV4Signature() {
        String dataNow;
        if (this.autoUpdateV4SigningAccessKey && !(dataNow = DATA_FORMAT.get().format(new Date())).equals(this.signingDate)) {
            this.signingDate = dataNow;
            this.v4SigningAccessKey = CalculateV4SigningKeyUtil.finalSigningKeyString(this.accessKeySecret, this.signingDate, this.region, "ots", "HmacSHA256");
        }
    }
}

