/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCodedOutputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferConversion;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCrc8;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferExtension;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferOutputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.core.utils.Pair;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import java.io.IOException;
import java.util.ArrayList;

public class PlainBufferBuilder {
    public static final int computePrimaryKeyValue(PrimaryKeyValue value) throws IOException {
        int size = 4;
        return size += PlainBufferBuilder.computePrimaryKeyValueWithoutLengthPrefix(value);
    }

    public static final int computeColumnValue(ColumnValue value) throws IOException {
        int size = 4;
        return size += PlainBufferBuilder.computeColumnValueWithoutLengthPrefix(value);
    }

    public static final int computePrimaryKeyValueWithoutLengthPrefix(PrimaryKeyValue value) throws IOException {
        int size = 1;
        if (value.isInfMin() || value.isInfMax() || value.isPlaceHolderForAutoIncr()) {
            return size;
        }
        switch (value.getType()) {
            case STRING: {
                size += 4;
                size += value.asStringInBytes().length;
                break;
            }
            case INTEGER: {
                size += 8;
                break;
            }
            case BINARY: {
                size += 4;
                size += value.asBinary().length;
                break;
            }
            default: {
                throw new IOException("Bug: unsupported primary key type: " + (Object)((Object)value.getType()));
            }
        }
        return size;
    }

    public static final int computeColumnValueWithoutLengthPrefix(ColumnValue value) throws IOException {
        int size = 1;
        switch (value.getType()) {
            case STRING: {
                size += 4;
                size += value.asStringInBytes().length;
                break;
            }
            case INTEGER: {
                size += 8;
                break;
            }
            case BINARY: {
                size += 4;
                size += value.asBinary().length;
                break;
            }
            case DOUBLE: {
                size += 8;
                break;
            }
            case BOOLEAN: {
                ++size;
                break;
            }
            default: {
                throw new IOException("Bug: unsupported column type: " + (Object)((Object)value.getType()));
            }
        }
        return size;
    }

    public static final int computePlainBufferExtension(PlainBufferExtension extension) {
        int size = 1;
        size += 4;
        if (extension.hasSeq()) {
            size += PlainBufferBuilder.computePlainBufferSequenceInfo();
        }
        return size;
    }

    public static final int computePlainBufferSequenceInfo() {
        int size = 1;
        size += 4;
        size += 5;
        size += 9;
        return size += 5;
    }

    public static final int computePlainBufferCell(PlainBufferCell cell) throws IOException {
        int size = 1;
        if (cell.hasCellName()) {
            ++size;
            size += 4;
            size += cell.getNameRawData().length;
        }
        if (cell.hasCellValue()) {
            ++size;
            size = cell.isPk() ? (size += PlainBufferBuilder.computePrimaryKeyValue(cell.getPkCellValue())) : (size += PlainBufferBuilder.computeColumnValue(cell.getCellValue()));
        }
        if (cell.hasCellType()) {
            size += 2;
        }
        if (cell.hasCellTimestamp()) {
            size += 9;
        }
        return size += 2;
    }

    public static final int computePlainBufferRow(PlainBufferRow row) throws IOException {
        int size = 0;
        ++size;
        for (PlainBufferCell cell : row.getPrimaryKey()) {
            size += PlainBufferBuilder.computePlainBufferCell(cell);
        }
        if (!row.getCells().isEmpty()) {
            ++size;
            for (PlainBufferCell cell : row.getCells()) {
                size += PlainBufferBuilder.computePlainBufferCell(cell);
            }
        }
        if (row.hasDeleteMarker()) {
            ++size;
        }
        if (row.hasExtension()) {
            size += PlainBufferBuilder.computePlainBufferExtension(row.getExtension());
        }
        return size += 2;
    }

    public static final int computePlainBufferRowWithHeader(PlainBufferRow row) throws IOException {
        int size = 4;
        return size += PlainBufferBuilder.computePlainBufferRow(row);
    }

    public static final int computeSkipLengthForExtensionTag(PlainBufferExtension extension) {
        int size = 0;
        if (extension.hasSeq()) {
            size += 5;
            size += PlainBufferBuilder.computeSkipLengthForSequenceInfo();
        }
        return size;
    }

    public static int computeSkipLengthForSequenceInfo() {
        int size = 0;
        size += 5;
        size += 9;
        return size += 5;
    }

    public static byte[] buildPrimaryKeyValueWithoutLengthPrefix(PrimaryKeyValue value) throws IOException {
        int size = PlainBufferBuilder.computePrimaryKeyValueWithoutLengthPrefix(value);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        PlainBufferCodedOutputStream codedOutput = new PlainBufferCodedOutputStream(output);
        codedOutput.writePrimaryKeyValueWithoutLengthPrefix(value);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize primary key value failed.");
        }
        return output.getBuffer();
    }

    public static byte[] buildColumnValueWithoutLengthPrefix(ColumnValue value) throws IOException {
        int size = PlainBufferBuilder.computeColumnValueWithoutLengthPrefix(value);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        PlainBufferCodedOutputStream codedOutput = new PlainBufferCodedOutputStream(output);
        codedOutput.writeColumnValueWithoutLengthPrefix(value);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize column value failed.");
        }
        return output.getBuffer();
    }

    public static final int computePrimaryKeyColumn(PrimaryKeyColumn column) throws IOException {
        int size = 2;
        size += 4;
        size += column.getNameRawData().length;
        ++size;
        size += PlainBufferBuilder.computePrimaryKeyValue(column.getValue());
        return size += 2;
    }

    public static final int computePrimaryKey(PrimaryKey primaryKey) throws IOException {
        int size = 1;
        for (PrimaryKeyColumn column : primaryKey.getPrimaryKeyColumns()) {
            size += PlainBufferBuilder.computePrimaryKeyColumn(column);
        }
        return size;
    }

    public static final int computePrimaryKeyWithHeader(PrimaryKey primaryKey) throws IOException {
        int size = 4;
        size += PlainBufferBuilder.computePrimaryKey(primaryKey);
        return size += 2;
    }

    public static void writePrimaryKeyValue(PrimaryKeyValue value, PlainBufferOutputStream output) throws IOException {
        if (value.isInfMin()) {
            output.writeRawLittleEndian32(1);
            output.writeRawByte((byte)9);
            return;
        }
        if (value.isInfMax()) {
            output.writeRawLittleEndian32(1);
            output.writeRawByte((byte)10);
            return;
        }
        if (value.isPlaceHolderForAutoIncr()) {
            output.writeRawLittleEndian32(1);
            output.writeRawByte((byte)11);
            return;
        }
        switch (value.getType()) {
            case STRING: {
                byte[] rawData = value.asStringInBytes();
                int prefixLength = 5;
                output.writeRawLittleEndian32(5 + rawData.length);
                output.writeRawByte((byte)3);
                output.writeRawLittleEndian32(rawData.length);
                output.writeBytes(rawData);
                break;
            }
            case INTEGER: {
                output.writeRawLittleEndian32(9);
                output.writeRawByte((byte)0);
                output.writeRawLittleEndian64(value.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = value.asBinary();
                int prefixLength = 5;
                output.writeRawLittleEndian32(5 + rawData.length);
                output.writeRawByte((byte)7);
                output.writeRawLittleEndian32(rawData.length);
                output.writeBytes(rawData);
                break;
            }
            default: {
                throw new IOException("Bug: unsupported primary key type: " + (Object)((Object)value.getType()));
            }
        }
    }

    public static void writePrimaryKeyColumn(PrimaryKeyColumn column, PlainBufferOutputStream output, byte checksum) throws IOException {
        output.writeRawByte((byte)3);
        output.writeRawByte((byte)4);
        byte[] rawData = column.getNameRawData();
        output.writeRawLittleEndian32(rawData.length);
        output.writeBytes(rawData);
        output.writeRawByte((byte)5);
        PlainBufferBuilder.writePrimaryKeyValue(column.getValue(), output);
        output.writeRawByte((byte)10);
        output.writeRawByte(checksum);
    }

    public static byte[] buildPrimaryKeyWithHeader(PrimaryKey primaryKey) throws IOException {
        int size = PlainBufferBuilder.computePrimaryKeyWithHeader(primaryKey);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        output.writeRawLittleEndian32(117);
        output.writeRawByte((byte)1);
        byte rowChecksum = 0;
        for (PrimaryKeyColumn column : primaryKey.getPrimaryKeyColumns()) {
            byte cellChecksum = PlainBufferCrc8.crc8((byte)0, column.getNameRawData());
            cellChecksum = column.getValue().getChecksum(cellChecksum);
            PlainBufferBuilder.writePrimaryKeyColumn(column, output, cellChecksum);
            rowChecksum = PlainBufferCrc8.crc8(rowChecksum, cellChecksum);
        }
        rowChecksum = PlainBufferCrc8.crc8(rowChecksum, (byte)0);
        output.writeRawByte((byte)9);
        output.writeRawByte(rowChecksum);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize primary key failed.");
        }
        return output.getBuffer();
    }

    public static byte[] buildRowPutChangeWithHeader(RowPutChange rowChange) throws IOException {
        ArrayList<PlainBufferCell> pkCells = new ArrayList<PlainBufferCell>();
        for (PrimaryKeyColumn column : rowChange.getPrimaryKey().getPrimaryKeyColumns()) {
            pkCells.add(PlainBufferConversion.toPlainBufferCell(column));
        }
        ArrayList<PlainBufferCell> cells = new ArrayList<PlainBufferCell>();
        for (Column column : rowChange.getColumnsToPut()) {
            cells.add(PlainBufferConversion.toPlainBufferCell(column, false, false, false, (byte)0));
        }
        PlainBufferRow row = new PlainBufferRow(pkCells, cells, false);
        int size = PlainBufferBuilder.computePlainBufferRowWithHeader(row);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        PlainBufferCodedOutputStream codedOutput = new PlainBufferCodedOutputStream(output);
        codedOutput.writeRowWithHeader(row);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize row put change failed.");
        }
        return output.getBuffer();
    }

    public static byte[] buildRowUpdateChangeWithHeader(RowUpdateChange rowChange) throws IOException {
        ArrayList<PlainBufferCell> pkCells = new ArrayList<PlainBufferCell>();
        for (PrimaryKeyColumn column : rowChange.getPrimaryKey().getPrimaryKeyColumns()) {
            pkCells.add(PlainBufferConversion.toPlainBufferCell(column));
        }
        ArrayList<PlainBufferCell> cells = new ArrayList<PlainBufferCell>();
        if (!rowChange.getColumnsToUpdate().isEmpty()) {
            for (Pair<Column, RowUpdateChange.Type> column : rowChange.getColumnsToUpdate()) {
                switch (column.getSecond()) {
                    case PUT: {
                        cells.add(PlainBufferConversion.toPlainBufferCell(column.getFirst(), false, false, false, (byte)0));
                        break;
                    }
                    case DELETE: {
                        cells.add(PlainBufferConversion.toPlainBufferCell(column.getFirst(), true, false, true, (byte)3));
                        break;
                    }
                    case DELETE_ALL: {
                        cells.add(PlainBufferConversion.toPlainBufferCell(column.getFirst(), true, true, true, (byte)1));
                        break;
                    }
                    case INCREMENT: {
                        cells.add(PlainBufferConversion.toPlainBufferCell(column.getFirst(), false, true, true, (byte)4));
                    }
                }
            }
        }
        PlainBufferRow row = new PlainBufferRow(pkCells, cells, false);
        int size = PlainBufferBuilder.computePlainBufferRowWithHeader(row);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        PlainBufferCodedOutputStream codedOutput = new PlainBufferCodedOutputStream(output);
        codedOutput.writeRowWithHeader(row);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize row update change failed.");
        }
        return output.getBuffer();
    }

    public static byte[] buildRowDeleteChangeWithHeader(RowDeleteChange rowChange) throws IOException {
        ArrayList<PlainBufferCell> pkCells = new ArrayList<PlainBufferCell>();
        for (PrimaryKeyColumn column : rowChange.getPrimaryKey().getPrimaryKeyColumns()) {
            pkCells.add(PlainBufferConversion.toPlainBufferCell(column));
        }
        ArrayList<PlainBufferCell> cells = new ArrayList<PlainBufferCell>();
        PlainBufferRow row = new PlainBufferRow(pkCells, cells, true);
        int size = PlainBufferBuilder.computePlainBufferRowWithHeader(row);
        PlainBufferOutputStream output = new PlainBufferOutputStream(size);
        PlainBufferCodedOutputStream codedOutput = new PlainBufferCodedOutputStream(output);
        codedOutput.writeRowWithHeader(row);
        if (!output.isFull()) {
            throw new IOException("Bug: serialize row delete change failed.");
        }
        return output.getBuffer();
    }
}

