/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.SQLResponseColumns;
import com.alicloud.openservices.tablestore.model.sql.SQLPayloadVersion;
import com.alicloud.openservices.tablestore.model.sql.SQLResultSet;
import com.alicloud.openservices.tablestore.model.sql.SQLResultSetImpl;
import com.alicloud.openservices.tablestore.model.sql.SQLRow;
import com.alicloud.openservices.tablestore.model.sql.SQLRowImpl;
import com.alicloud.openservices.tablestore.model.sql.SQLRows;
import com.alicloud.openservices.tablestore.model.sql.SQLRowsFBsColumnBased;
import com.alicloud.openservices.tablestore.model.sql.SQLStatementType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import java.nio.ByteBuffer;

public class SQLFactory {
    public static SQLResultSet getSQLResultSet(SQLPayloadVersion version, SQLStatementType type, ByteString rows) {
        switch (type) {
            case SQL_SELECT: 
            case SQL_SHOW_TABLE: 
            case SQL_DESCRIBE_TABLE: {
                return new SQLResultSetImpl(version, rows);
            }
        }
        return null;
    }

    public static SQLRows getSQLRows(SQLPayloadVersion version, ByteString rows) {
        switch (version) {
            case SQL_FLAT_BUFFERS: {
                if (!rows.isEmpty()) {
                    ByteBuffer rowBuffer = rows.asReadOnlyByteBuffer();
                    SQLResponseColumns columns = SQLResponseColumns.getRootAsSQLResponseColumns(rowBuffer);
                    return new SQLRowsFBsColumnBased(columns);
                }
                throw new IllegalStateException("Sql response get rows should not be null");
            }
        }
        throw new IllegalStateException("Do not support other sql payload version: " + (Object)((Object)version));
    }

    public static SQLRow getSQLRow(SQLRows sqlRows, int rowIndex) {
        return new SQLRowImpl(sqlRows, rowIndex);
    }
}

