/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.nio;

import com.aliyun.ots.thirdparty.org.apache.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.HttpEntityEnclosingRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpException;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.HttpResponseFactory;
import com.aliyun.ots.thirdparty.org.apache.annotation.NotThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.config.MessageConstraints;
import com.aliyun.ots.thirdparty.org.apache.entity.ContentLengthStrategy;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.NHttpClientEventHandlerAdaptor;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.NHttpConnectionBase;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.codecs.DefaultHttpRequestWriter;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.codecs.DefaultHttpResponseParser;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.codecs.DefaultHttpResponseParserFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpClientEventHandler;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpClientHandler;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpClientIOTarget;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageParser;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageParserFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageWriter;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpMessageWriterFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.IOSession;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.SessionInputBuffer;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.SessionOutputBuffer;
import com.aliyun.ots.thirdparty.org.apache.nio.util.ByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.params.HttpParamConfig;
import com.aliyun.ots.thirdparty.org.apache.params.HttpParams;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultNHttpClientConnection
extends NHttpConnectionBase
implements NHttpClientIOTarget {
    protected final NHttpMessageParser<HttpResponse> responseParser;
    protected final NHttpMessageWriter<HttpRequest> requestWriter;

    @Deprecated
    public DefaultNHttpClientConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, allocator, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseParser = this.createResponseParser(this.inbuf, responseFactory, params);
        this.requestWriter = this.createRequestWriter(this.outbuf, params);
        this.hasBufferedInput = false;
        this.hasBufferedOutput = false;
        this.session.setBufferStatus(this);
    }

    public DefaultNHttpClientConnection(IOSession session, int buffersize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(session, buffersize, fragmentSizeHint, allocator, chardecoder, charencoder, incomingContentStrategy, outgoingContentStrategy);
        this.requestWriter = (requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.outbuf);
        this.responseParser = (responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.inbuf, constraints);
    }

    public DefaultNHttpClientConnection(IOSession session, int buffersize, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints) {
        this(session, buffersize, buffersize, null, chardecoder, charencoder, constraints, null, null, null, null);
    }

    public DefaultNHttpClientConnection(IOSession session, int buffersize) {
        this(session, buffersize, buffersize, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        MessageConstraints constraints = HttpParamConfig.getMessageConstraints(params);
        return new DefaultHttpResponseParser(buffer, null, responseFactory, constraints);
    }

    @Deprecated
    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new DefaultHttpRequestWriter(buffer, null);
    }

    protected void onResponseReceived(HttpResponse response) {
    }

    protected void onRequestSubmitted(HttpRequest request) {
    }

    @Override
    public void resetInput() {
        this.response = null;
        this.contentDecoder = null;
        this.responseParser.reset();
    }

    @Override
    public void resetOutput() {
        this.request = null;
        this.contentEncoder = null;
        this.requestWriter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpClientEventHandler handler) {
        if (this.status != 0) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.response == null) {
                int bytesRead;
                do {
                    if ((bytesRead = this.responseParser.fillBuffer(this.session.channel())) > 0) {
                        this.inTransportMetrics.incrementBytesTransferred(bytesRead);
                    }
                    this.response = this.responseParser.parse();
                } while (bytesRead > 0 && this.response == null);
                if (this.response != null) {
                    if (this.response.getStatusLine().getStatusCode() >= 200) {
                        HttpEntity entity = this.prepareDecoder(this.response);
                        this.response.setEntity(entity);
                        this.connMetrics.incrementResponseCount();
                    }
                    this.onResponseReceived(this.response);
                    handler.responseReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (bytesRead == -1) {
                    handler.endOfInput(this);
                }
            }
            if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                handler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (HttpException ex) {
            this.resetInput();
            handler.exception(this, ex);
        }
        catch (Exception ex) {
            handler.exception(this, ex);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(NHttpClientEventHandler handler) {
        try {
            int bytesWritten;
            if (this.status == 0) {
                if (this.contentEncoder == null) {
                    handler.requestReady(this);
                }
                if (this.contentEncoder != null) {
                    handler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
            }
            if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush(this.session.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(bytesWritten);
            }
            if (!this.outbuf.hasData()) {
                if (this.status == 1) {
                    this.session.close();
                    this.status = 2;
                    this.resetOutput();
                }
                if (this.contentEncoder == null && this.status != 2) {
                    this.session.clearEvent(4);
                }
            }
        }
        catch (Exception ex) {
            handler.exception(this, ex);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    @Override
    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        this.assertNotClosed();
        if (this.request != null) {
            throw new HttpException("Request already submitted");
        }
        this.onRequestSubmitted(request);
        this.requestWriter.write(request);
        this.hasBufferedOutput = this.outbuf.hasData();
        if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
            this.prepareEncoder(request);
            this.request = request;
        }
        this.connMetrics.incrementRequestCount();
        this.session.setEvent(4);
    }

    @Override
    public boolean isRequestSubmitted() {
        return this.request != null;
    }

    @Override
    public void consumeInput(NHttpClientHandler handler) {
        this.consumeInput(new NHttpClientEventHandlerAdaptor(handler));
    }

    @Override
    public void produceOutput(NHttpClientHandler handler) {
        this.produceOutput(new NHttpClientEventHandlerAdaptor(handler));
    }
}

