/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.util;

import com.aliyun.ots.thirdparty.org.apache.annotation.NotThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.nio.ContentEncoder;
import com.aliyun.ots.thirdparty.org.apache.nio.util.ByteBufferAllocator;
import com.aliyun.ots.thirdparty.org.apache.nio.util.ContentOutputBuffer;
import com.aliyun.ots.thirdparty.org.apache.nio.util.ExpandableBuffer;
import com.aliyun.ots.thirdparty.org.apache.nio.util.HeapByteBufferAllocator;
import java.io.IOException;

@NotThreadSafe
public class SimpleOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private boolean endOfStream = false;

    public SimpleOutputBuffer(int buffersize, ByteBufferAllocator allocator) {
        super(buffersize, allocator);
    }

    public SimpleOutputBuffer(int buffersize) {
        this(buffersize, HeapByteBufferAllocator.INSTANCE);
    }

    public int produceContent(ContentEncoder encoder) throws IOException {
        this.setOutputMode();
        int bytesWritten = encoder.write(this.buffer);
        if (!this.hasData() && this.endOfStream) {
            encoder.complete();
        }
        return bytesWritten;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.buffer.position() + len);
        this.buffer.put(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.capacity() + 1);
        this.buffer.put((byte)b);
    }

    public void reset() {
        super.clear();
        this.endOfStream = false;
    }

    public void flush() {
    }

    public void writeCompleted() {
        this.endOfStream = true;
    }

    public void shutdown() {
        this.endOfStream = true;
    }
}

