/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.imageclassify;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class AipImageClassify
extends BaseClient {
    public AipImageClassify(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject advancedGeneral(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v2/advanced_general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject advancedGeneral(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.advancedGeneral(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject dishDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v2/dish");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject dishDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.dishDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject carDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/car");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject carDetectUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/car");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject carDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.carDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleDetectUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleDamage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_damage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleDamage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.vehicleDamage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject logoSearch(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v2/logo");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject logoSearch(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.logoSearch(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject logoAdd(byte[] image, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/v1/logo/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject logoAdd(String image, String brief, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.logoAdd(data, brief, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject logoDeleteByImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/v1/logo/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject logoDeleteByImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.logoDeleteByImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject logoDeleteBySign(String contSign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign", contSign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/v1/logo/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject animalDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/animal");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject animalDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.animalDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject plantDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/plant");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject plantDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.plantDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject objectDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/object_detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject objectDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.objectDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject landmark(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/landmark");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject landmark(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.landmark(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject flower(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/flower");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject flower(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.flower(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject ingredient(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/classify/ingredient");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject ingredient(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.ingredient(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject redwine(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/redwine");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwine(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.redwine(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject currency(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/currency");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject currency(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.currency(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject customDishesAddImage(String image, String brief, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.customDishesAddImage(data, brief, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject customDishesAddImage(byte[] image, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/dish/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject customDishesSearch(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.customDishesSearch(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject customDishesSearch(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/dish/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject customDishesDeleteImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.customDishesDeleteImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject customDishesDeleteImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/dish/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject customDishesDeleteContSign(String contSign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign", contSign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/dish/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiObjectDetect(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.multiObjectDetect(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject multiObjectDetect(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/multi_object_detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject combinationByImage(String image, List<String> scenes, HashMap<String, Object> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.combinationByImage(data, scenes, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject combinationByImage(byte[] image, List<String> scenes, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request, "application/json");
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("scenes", scenes);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/api/v1/solution/direct/imagerecognition/combination");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject combinationByImageUrl(String imgUrl, List<String> scenes, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request, "application/json");
        request.addBody("imgUrl", imgUrl);
        request.addBody("scenes", scenes);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/api/v1/solution/direct/imagerecognition/combination");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleAttr(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_attr");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleAttrUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_attr");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleDetectHigh(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_detect_high");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleDetectHighUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_detect_high");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleSeg(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("image", image);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/vehicle_seg");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject trafficFlow(byte[] image, int caseId, String caseInit, String area, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("case_id", caseId);
        request.addBody("case_init", caseInit);
        request.addBody("area", area);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/traffic_flow");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject trafficFlowUrl(String url, int caseId, String caseInit, String area, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.addBody("case_id", caseId);
        request.addBody("case_init", caseInit);
        request.addBody("area", area);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/traffic_flow");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineAddV1Image(byte[] image, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineAddV1Url(String url, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineSearchV1Image(byte[] image, String customLib, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("custom_lib", customLib);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineSearchV1Url(String url, String customLib, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.addBody("custom_lib", customLib);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineDeleteV1Image(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineDeleteV1Sign(String sign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign_list", sign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineUpdateV1Image(byte[] image, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject redwineUpdateV1Url(String url, String brief, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        request.addBody("brief", brief);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/redwine/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleAttrClassifyV2Image(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v2/vehicle_attr");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleAttrClassifyV2Url(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v2/vehicle_attr");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

