/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.registry.impl;

import com.baidu.unbiz.fluentvalidator.registry.Registry;
import com.baidu.unbiz.fluentvalidator.registry.impl.SimpleRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringApplicationContextRegistry
implements Registry,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringApplicationContextRegistry.class);
    private ApplicationContext applicationContext;
    private Registry simpleRegistry = new SimpleRegistry();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public <T> List<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        if (map == null || map.isEmpty()) {
            LOGGER.warn("Not found from Spring IoC container for " + type.getSimpleName() + ", and try to init by " + "calling newInstance.");
            return this.simpleRegistry.findByType(type);
        }
        return new ArrayList<T>(map.values());
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type);
    }
}

