/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.acl;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.acl.AclClient;
import com.baidubce.services.acl.AclClientConfiguration;
import com.baidubce.services.acl.model.AclRule;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class ExampleAddAclRule {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "bcc.bj.baidubce.com";
        AclClientConfiguration config = new AclClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        AclClient aclClient = new AclClient(config);
        AclRule aclRule = new AclRule();
        aclRule.setSubnetId("sbn-6ha6gp1vczuv");
        aclRule.setAction("allow");
        aclRule.setDescription("acl rule");
        aclRule.setDirection("ingress");
        aclRule.setName("acl_name");
        aclRule.setPosition(9000);
        aclRule.setProtocol("all");
        aclRule.setDestinationIpAddress("192.168.0.8");
        aclRule.setDestinationPort("80");
        aclRule.setSourceIpAddress("all");
        aclRule.setSourcePort("90");
        ArrayList aclRules = Lists.newArrayList((Object[])new AclRule[]{aclRule});
        try {
            aclClient.createAcl(aclRules);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

