/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.CreateDatasetRequest;
import com.baidubce.services.aihc.model.dataset.CreateDatasetResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;
import java.util.ArrayList;

public class ExampleCreateDataset {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        CreateDatasetRequest request = new CreateDatasetRequest();
        request.setName("test-dataset-11111");
        request.setStorageType("BOS");
        request.setStorageInstance("bucket1");
        request.setImportFormat("FOLDER");
        request.setVisibilityScope("USER_GROUP");
        request.setDescription("test dataset");
        request.setOwner("xxx");
        ArrayList<CreateDatasetRequest.PermissionEntry> visibilityUser = new ArrayList<CreateDatasetRequest.PermissionEntry>();
        CreateDatasetRequest.PermissionEntry user1 = new CreateDatasetRequest.PermissionEntry();
        user1.setId("xxxxx");
        user1.setName("lisi");
        user1.setPermission("r");
        visibilityUser.add(user1);
        CreateDatasetRequest.PermissionEntry user2 = new CreateDatasetRequest.PermissionEntry();
        user2.setId("xxxxx");
        user2.setName("wangwu");
        user2.setPermission("rw");
        visibilityUser.add(user2);
        request.setVisibilityUser(visibilityUser);
        ArrayList<CreateDatasetRequest.PermissionEntry> visibilityGroup = new ArrayList<CreateDatasetRequest.PermissionEntry>();
        CreateDatasetRequest.PermissionEntry group1 = new CreateDatasetRequest.PermissionEntry();
        group1.setId("group1");
        group1.setName("\u5f00\u53d1\u7ec4");
        group1.setPermission("r");
        visibilityGroup.add(group1);
        request.setVisibilityGroup(visibilityGroup);
        CreateDatasetRequest.DatasetVersionEntry initVersionEntry = new CreateDatasetRequest.DatasetVersionEntry();
        initVersionEntry.setDescription("dataset first version");
        initVersionEntry.setStoragePath("/path/to/dir");
        initVersionEntry.setMountPath("/mnt/datasets/test1");
        request.setInitVersionEntry(initVersionEntry);
        try {
            System.out.println("=== \u5f00\u59cb\u521b\u5efa\u6570\u636e\u96c6 ===");
            System.out.println("\u6570\u636e\u96c6\u540d\u79f0: " + request.getName());
            System.out.println("\u5b58\u50a8\u7c7b\u578b: " + request.getStorageType());
            System.out.println("\u5b58\u50a8\u5b9e\u4f8b: " + request.getStorageInstance());
            System.out.println("\u5bfc\u5165\u683c\u5f0f: " + request.getImportFormat());
            System.out.println("\u53ef\u89c1\u8303\u56f4: " + request.getVisibilityScope());
            System.out.println("\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\n--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            CreateDatasetResponse response = client.dataset().createDataset(request);
            System.out.println("\u6570\u636e\u96c6\u521b\u5efa\u6210\u529f\uff01");
            System.out.println("\u6570\u636e\u96c6ID: " + response.getId());
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            request.setName("test22222");
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            CreateDatasetResponse response2 = datasetModule.createDataset(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u521b\u5efa\u6570\u636e\u96c6\u6210\u529f\uff01");
            System.out.println("\u6570\u636e\u96c6ID: " + response2.getId());
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
            System.out.println("\n=== \u521b\u5efa\u7684\u6570\u636e\u96c6\u4fe1\u606f ===");
            System.out.println("\u6570\u636e\u96c6ID: " + response.getId());
            System.out.println("\u6570\u636e\u96c6\u540d\u79f0: " + request.getName());
            System.out.println("\u5b58\u50a8\u7c7b\u578b: " + request.getStorageType());
            System.out.println("\u5b58\u50a8\u5b9e\u4f8b: " + request.getStorageInstance());
            System.out.println("\u5bfc\u5165\u683c\u5f0f: " + request.getImportFormat());
            System.out.println("\u53ef\u89c1\u8303\u56f4: " + request.getVisibilityScope());
            System.out.println("\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\u521d\u59cb\u7248\u672c\u63cf\u8ff0: " + initVersionEntry.getDescription());
            System.out.println("\u5b58\u50a8\u8def\u5f84: " + initVersionEntry.getStoragePath());
            System.out.println("\u6302\u8f7d\u8def\u5f84: " + initVersionEntry.getMountPath());
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

