/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.CreateDatasetVersionRequest;
import com.baidubce.services.aihc.model.dataset.CreateDatasetVersionResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;

public class ExampleCreateDatasetVersion {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        CreateDatasetVersionRequest request = new CreateDatasetVersionRequest();
        request.setDatasetId(System.getenv("DATASET_ID"));
        request.setStoragePath("/path/to/version2");
        request.setMountPath("/mnt/datasets/my-dataset-1/v2");
        request.setDescription("new version");
        try {
            System.out.println("=== \u5f00\u59cb\u521b\u5efa\u6570\u636e\u96c6\u7248\u672c ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\u7248\u672c\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\u5b58\u50a8\u8def\u5f84: " + request.getStoragePath());
            System.out.println("\u6302\u8f7d\u8def\u5f84: " + request.getMountPath());
            System.out.println("\n--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            CreateDatasetVersionResponse response = client.dataset().createDatasetVersion(request);
            System.out.println("\u6570\u636e\u96c6\u7248\u672c\u521b\u5efa\u6210\u529f\uff01");
            System.out.println("\u7248\u672cID: " + response.getId());
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            CreateDatasetVersionResponse response2 = datasetModule.createDatasetVersion(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u521b\u5efa\u6570\u636e\u96c6\u7248\u672c\u6210\u529f\uff01");
            System.out.println("\u7248\u672cID: " + response2.getId());
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
            System.out.println("\n=== \u521b\u5efa\u7684\u6570\u636e\u96c6\u7248\u672c\u4fe1\u606f ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\u7248\u672cID: " + response.getId());
            System.out.println("\u7248\u672c\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\u5b58\u50a8\u8def\u5f84: " + request.getStoragePath());
            System.out.println("\u6302\u8f7d\u8def\u5f84: " + request.getMountPath());
            System.out.println("\n=== \u6ce8\u610f\u4e8b\u9879 ===");
            System.out.println("\u65b0\u521b\u5efa\u7684\u7248\u672c\u5c06\u6210\u4e3a\u6570\u636e\u96c6\u7684\u6700\u65b0\u7248\u672c\u3002");
            System.out.println("\u8bf7\u786e\u4fdd\u5b58\u50a8\u8def\u5f84\u4e2d\u7684\u6570\u636e\u5df2\u7ecf\u51c6\u5907\u597d\u3002");
            System.out.println("\u6302\u8f7d\u8def\u5f84\u5c06\u5728\u4f7f\u7528\u6570\u636e\u96c6\u65f6\u751f\u6548\u3002");
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

