/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetRequest;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;

public class ExampleDeleteDataset {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        DeleteDatasetRequest request = new DeleteDatasetRequest();
        request.setDatasetId(System.getenv("DATASET_ID"));
        try {
            System.out.println("=== \u5f00\u59cb\u5220\u9664\u6570\u636e\u96c6 ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\n--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DeleteDatasetResponse response = client.dataset().deleteDataset(request);
            System.out.println("\u6570\u636e\u96c6\u5220\u9664\u6210\u529f\uff01");
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            DeleteDatasetResponse response2 = datasetModule.deleteDataset(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u5220\u9664\u6570\u636e\u96c6\u6210\u529f\uff01");
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
            System.out.println("\n=== \u6ce8\u610f\u4e8b\u9879 ===");
            System.out.println("\u5220\u9664\u64cd\u4f5c\u662f\u4e0d\u53ef\u9006\u7684\uff0c\u6570\u636e\u96c6\u53ca\u5176\u6240\u6709\u7248\u672c\u5c06\u88ab\u6c38\u4e45\u5220\u9664\u3002");
            System.out.println("\u8bf7\u786e\u4fdd\u60a8\u8981\u5220\u9664\u7684\u6570\u636e\u96c6\u4e0d\u518d\u88ab\u4f7f\u7528\u3002");
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

