/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetVersionRequest;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetVersionResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;

public class ExampleDeleteDatasetVersion {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID");
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY");
        if (ak == null || sk == null || "Your AK".equals(ak) || "Your SK".equals(sk)) {
            System.out.println("\u274c \u73af\u5883\u53d8\u91cf\u672a\u8bbe\u7f6e\uff01");
            System.out.println("\u8bf7\u8bbe\u7f6e\u4ee5\u4e0b\u73af\u5883\u53d8\u91cf\uff1a");
            System.out.println("export BCE_ACCESS_KEY_ID=\"your-access-key\"");
            System.out.println("export BCE_SECRET_ACCESS_KEY=\"your-secret-key\"");
            System.out.println();
            System.out.println("\u26a0\ufe0f  \u6ce8\u610f\uff1a\u5220\u9664\u64cd\u4f5c\u662f\u4e0d\u53ef\u9006\u7684\uff0c\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684\u8bbf\u95ee\u5bc6\u94a5\uff01");
            return;
        }
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        DeleteDatasetVersionRequest request = new DeleteDatasetVersionRequest();
        String datasetId = System.getenv("DATASET_ID");
        String versionId = System.getenv("DATASET_VERSION_ID");
        request.setDatasetId(datasetId);
        request.setVersionId(versionId);
        try {
            System.out.println("=== \u5f00\u59cb\u5220\u9664\u6570\u636e\u96c6\u7248\u672c ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\u7248\u672cID: " + request.getVersionId());
            System.out.println();
            System.out.println("\u26a0\ufe0f  \u8b66\u544a\uff1a\u6b64\u64cd\u4f5c\u5c06\u6c38\u4e45\u5220\u9664\u6307\u5b9a\u7684\u6570\u636e\u96c6\u7248\u672c\uff01");
            System.out.println("\u8bf7\u786e\u8ba4\u60a8\u8981\u5220\u9664\u7684\u7248\u672c\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002");
            System.out.println();
            System.out.println("--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DeleteDatasetVersionResponse response = client.dataset().deleteDatasetVersion(request);
            System.out.println("\u2705 \u6570\u636e\u96c6\u7248\u672c\u5220\u9664\u6210\u529f\uff01");
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
            System.out.println("\n=== \u64cd\u4f5c\u5b8c\u6210 ===");
            System.out.println("\u2705 \u6570\u636e\u96c6\u7248\u672c\u5220\u9664\u64cd\u4f5c\u5df2\u6210\u529f\u5b8c\u6210");
            System.out.println("\ud83d\udccb \u5220\u9664\u7684\u7248\u672c\u4fe1\u606f\uff1a");
            System.out.println("   - \u6570\u636e\u96c6ID: " + datasetId);
            System.out.println("   - \u7248\u672cID: " + versionId);
            System.out.println("   - \u8bf7\u6c42ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            DeleteDatasetVersionResponse response2 = datasetModule.deleteDatasetVersion(request);
            System.out.println("\u2705 \u6a21\u5757\u5316\u65b9\u5f0f\u5220\u9664\u6570\u636e\u96c6\u7248\u672c\u6210\u529f\uff01");
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
        }
        catch (BceClientException e) {
            System.err.println("\u274c API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
            System.err.println();
            System.err.println("\u53ef\u80fd\u7684\u539f\u56e0\uff1a");
            System.err.println("1. \u8bbf\u95ee\u5bc6\u94a5\u65e0\u6548\u6216\u6743\u9650\u4e0d\u8db3");
            System.err.println("2. \u6570\u636e\u96c6ID\u6216\u7248\u672cID\u4e0d\u5b58\u5728");
            System.err.println("3. \u7f51\u7edc\u8fde\u63a5\u95ee\u9898");
            System.err.println("4. \u670d\u52a1\u7aef\u70b9\u4e0d\u53ef\u7528");
            System.err.println();
            System.err.println("\u5efa\u8bae\u7684\u89e3\u51b3\u65b9\u6848\uff1a");
            System.err.println("1. \u68c0\u67e5\u73af\u5883\u53d8\u91cf\u8bbe\u7f6e\u662f\u5426\u6b63\u786e");
            System.err.println("2. \u9a8c\u8bc1\u6570\u636e\u96c6ID\u548c\u7248\u672cID\u662f\u5426\u5b58\u5728");
            System.err.println("3. \u786e\u8ba4\u7f51\u7edc\u8fde\u63a5\u6b63\u5e38");
            System.err.println("4. \u68c0\u67e5\u8d26\u6237\u6743\u9650\u662f\u5426\u8db3\u591f");
        }
        catch (Exception e) {
            System.err.println("\u274c \u7a0b\u5e8f\u6267\u884c\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

