/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;
import java.util.Iterator;

public class ExampleDescribeDataset {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        DescribeDatasetRequest request = new DescribeDatasetRequest();
        request.setDatasetId(System.getenv("DATASET_ID"));
        try {
            System.out.println("--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DescribeDatasetResponse response = client.dataset().describeDataset(request);
            System.out.println("\u6570\u636e\u96c6ID: " + response.getId());
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            DescribeDatasetResponse response2 = datasetModule.describeDataset(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u67e5\u8be2\u6570\u636e\u96c6ID: " + response2.getId());
            System.out.println("\u6570\u636e\u96c6\u540d\u79f0: " + response.getName());
            System.out.println("\u5b58\u50a8\u7c7b\u578b: " + response.getStorageType());
            System.out.println("\u5b58\u50a8\u5b9e\u4f8b: " + response.getStorageInstance());
            System.out.println("\u5bfc\u5165\u683c\u5f0f: " + response.getImportFormat());
            System.out.println("\u63cf\u8ff0: " + response.getDescription());
            System.out.println("\u6240\u6709\u8005: " + response.getOwner());
            System.out.println("\u6240\u6709\u8005\u540d\u79f0: " + response.getOwnerName());
            System.out.println("\u53ef\u89c1\u8303\u56f4: " + response.getVisibilityScope());
            System.out.println("\u6743\u9650: " + response.getPermission());
            System.out.println("\u6700\u65b0\u7248\u672cID: " + response.getLatestVersionId());
            System.out.println("\u6700\u65b0\u7248\u672c\u53f7: " + response.getLatestVersion());
            System.out.println("\u521b\u5efa\u65f6\u95f4: " + response.getCreatedAt());
            System.out.println("\u66f4\u65b0\u65f6\u95f4: " + response.getUpdatedAt());
            if (response.getLatestVersionEntry() != null) {
                Iterator<DescribeDatasetResponse.PermissionEntry> latestVersionEntry = response.getLatestVersionEntry();
                System.out.println("\n=== \u6700\u65b0\u7248\u672c\u4fe1\u606f ===");
                System.out.println("\u7248\u672cID: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getId());
                System.out.println("\u7248\u672c\u53f7: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getVersion());
                System.out.println("\u7248\u672c\u63cf\u8ff0: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getDescription());
                System.out.println("\u5b58\u50a8\u8def\u5f84: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getStoragePath());
                System.out.println("\u6302\u8f7d\u8def\u5f84: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getMountPath());
                System.out.println("\u521b\u5efa\u7528\u6237: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getCreateUser());
                System.out.println("\u521b\u5efa\u7528\u6237\u540d: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getCreateUserName());
                System.out.println("\u7248\u672c\u521b\u5efa\u65f6\u95f4: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getCreatedAt());
                System.out.println("\u7248\u672c\u66f4\u65b0\u65f6\u95f4: " + ((DescribeDatasetResponse.DatasetVersionEntry)((Object)latestVersionEntry)).getUpdatedAt());
            }
            if (response.getVisibilityUser() != null && !response.getVisibilityUser().isEmpty()) {
                System.out.println("\n=== \u7528\u6237\u6743\u9650\u5217\u8868 ===");
                for (DescribeDatasetResponse.PermissionEntry user : response.getVisibilityUser()) {
                    System.out.println("\u7528\u6237ID: " + user.getId() + ", \u7528\u6237\u540d: " + user.getName() + ", \u6743\u9650: " + user.getPermission());
                }
            }
            if (response.getVisibilityGroup() != null && !response.getVisibilityGroup().isEmpty()) {
                System.out.println("\n=== \u7528\u6237\u7ec4\u6743\u9650\u5217\u8868 ===");
                for (DescribeDatasetResponse.PermissionEntry group : response.getVisibilityGroup()) {
                    System.out.println("\u7528\u6237\u7ec4ID: " + group.getId() + ", \u7528\u6237\u7ec4\u540d: " + group.getName() + ", \u6743\u9650: " + group.getPermission());
                }
            }
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

