/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionsRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionsResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;

public class ExampleDescribeDatasetVersions {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        DescribeDatasetVersionsRequest request = new DescribeDatasetVersionsRequest();
        request.setDatasetId(System.getenv("DATASET_ID"));
        request.setPageNumber(1);
        request.setPageSize(10);
        try {
            System.out.println("--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DescribeDatasetVersionsResponse response = client.dataset().describeDatasetVersions(request);
            System.out.println("\u6570\u636e\u96c6\u7248\u672c\u603b\u6570: " + response.getTotalCount());
            System.out.println("\u5f53\u524d\u9875\u7248\u672c\u6570\u91cf: " + (response.getVersions() != null ? response.getVersions().size() : 0));
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            DescribeDatasetVersionsResponse response2 = datasetModule.describeDatasetVersions(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u67e5\u8be2\u6570\u636e\u96c6\u7248\u672c\u603b\u6570: " + response2.getTotalCount());
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u5f53\u524d\u9875\u7248\u672c\u6570\u91cf: " + (response2.getVersions() != null ? response2.getVersions().size() : 0));
            if (response.getVersions() != null && !response.getVersions().isEmpty()) {
                System.out.println("\n=== \u6570\u636e\u96c6\u7248\u672c\u5217\u8868 ===");
                for (int i = 0; i < response.getVersions().size(); ++i) {
                    DescribeDatasetVersionsResponse.DatasetVersionEntry version = response.getVersions().get(i);
                    System.out.println("\n--- \u7248\u672c " + (i + 1) + " ---");
                    System.out.println("\u7248\u672cID: " + version.getId());
                    System.out.println("\u7248\u672c\u53f7: " + version.getVersion());
                    System.out.println("\u7248\u672c\u63cf\u8ff0: " + version.getDescription());
                    System.out.println("\u5b58\u50a8\u8def\u5f84: " + version.getStoragePath());
                    System.out.println("\u6302\u8f7d\u8def\u5f84: " + version.getMountPath());
                    System.out.println("\u521b\u5efa\u7528\u6237: " + version.getCreateUser());
                    System.out.println("\u521b\u5efa\u7528\u6237\u540d: " + version.getCreateUserName());
                    System.out.println("\u521b\u5efa\u65f6\u95f4: " + version.getCreatedAt());
                    System.out.println("\u66f4\u65b0\u65f6\u95f4: " + version.getUpdatedAt());
                }
            } else {
                System.out.println("\n=== \u6570\u636e\u96c6\u7248\u672c\u5217\u8868 ===");
                System.out.println("\u6682\u65e0\u7248\u672c\u6570\u636e");
            }
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

