/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.dataset.ModifyDatasetRequest;
import com.baidubce.services.aihc.model.dataset.ModifyDatasetResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;
import com.baidubce.util.JsonUtils;
import java.util.ArrayList;

public class ExampleModifyDataset {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = System.getenv("ENDPOINT") != null ? System.getenv("ENDPOINT") : "AIHC_ENDPOINT";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        ModifyDatasetRequest request = new ModifyDatasetRequest();
        request.setDatasetId(System.getenv("DATASET_ID"));
        request.setName("my-dataset-1");
        request.setDescription("my dataset test modify");
        request.setVisibilityScope("ALL_PEOPLE");
        ArrayList<ModifyDatasetRequest.PermissionEntry> visibilityUser = new ArrayList<ModifyDatasetRequest.PermissionEntry>();
        ModifyDatasetRequest.PermissionEntry user1 = new ModifyDatasetRequest.PermissionEntry();
        user1.setId("xxxxx");
        user1.setName("lisi");
        user1.setPermission("r");
        visibilityUser.add(user1);
        ModifyDatasetRequest.PermissionEntry user2 = new ModifyDatasetRequest.PermissionEntry();
        user2.setId("xxxxx");
        user2.setName("wangwu");
        user2.setPermission("rw");
        visibilityUser.add(user2);
        ArrayList<ModifyDatasetRequest.PermissionEntry> visibilityGroup = new ArrayList<ModifyDatasetRequest.PermissionEntry>();
        ModifyDatasetRequest.PermissionEntry group1 = new ModifyDatasetRequest.PermissionEntry();
        group1.setId("group1");
        group1.setName("\u5f00\u53d1\u7ec4");
        group1.setPermission("r");
        visibilityGroup.add(group1);
        try {
            System.out.println("=== \u5f00\u59cb\u4fee\u6539\u6570\u636e\u96c6 ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\u65b0\u540d\u79f0: " + request.getName());
            System.out.println("\u65b0\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\u65b0\u53ef\u89c1\u8303\u56f4: " + request.getVisibilityScope());
            System.out.println("\n--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            ModifyDatasetResponse response = client.dataset().modifyDataset(request);
            System.out.println("\u6570\u636e\u96c6\u4fee\u6539\u6210\u529f\uff01");
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            DatasetModule datasetModule = client.dataset();
            ModifyDatasetResponse response2 = datasetModule.modifyDataset(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u4fee\u6539\u6570\u636e\u96c6\u6210\u529f\uff01");
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
            System.out.println("\n=== \u4fee\u6539\u7684\u6570\u636e\u96c6\u4fe1\u606f ===");
            System.out.println("\u6570\u636e\u96c6ID: " + request.getDatasetId());
            System.out.println("\u6570\u636e\u96c6\u540d\u79f0: " + request.getName());
            System.out.println("\u6570\u636e\u96c6\u63cf\u8ff0: " + request.getDescription());
            System.out.println("\u53ef\u89c1\u8303\u56f4: " + request.getVisibilityScope());
            if (request.getVisibilityUser() != null && !request.getVisibilityUser().isEmpty()) {
                System.out.println("\u7528\u6237\u6743\u9650\u5217\u8868:");
                for (ModifyDatasetRequest.PermissionEntry user : request.getVisibilityUser()) {
                    System.out.println("  - \u7528\u6237ID: " + user.getId() + ", \u7528\u6237\u540d: " + user.getName() + ", \u6743\u9650: " + user.getPermission());
                }
            }
            if (request.getVisibilityGroup() != null && !request.getVisibilityGroup().isEmpty()) {
                System.out.println("\u7528\u6237\u7ec4\u6743\u9650\u5217\u8868:");
                for (ModifyDatasetRequest.PermissionEntry group : request.getVisibilityGroup()) {
                    System.out.println("  - \u7528\u6237\u7ec4ID: " + group.getId() + ", \u7528\u6237\u7ec4\u540d: " + group.getName() + ", \u6743\u9650: " + group.getPermission());
                }
            }
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
    }
}

