/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.model;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.model.DescribeModelRequest;
import com.baidubce.services.aihc.model.model.DescribeModelResponse;
import com.baidubce.services.aihc.modules.model.ModelModule;

public class ExampleDescribeModel {
    public static void main(String[] args) {
        String accessKey = System.getenv("BCE_ACCESS_KEY_ID");
        String secretKey = System.getenv("BCE_SECRET_ACCESS_KEY");
        if (accessKey == null || secretKey == null) {
            System.out.println("\u8bf7\u8bbe\u7f6e\u73af\u5883\u53d8\u91cf BCE_ACCESS_KEY_ID \u548c BCE_SECRET_ACCESS_KEY");
            return;
        }
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(accessKey, secretKey));
        config.setEndpoint("aihc.bj.baidubce.com");
        AihcClient client = new AihcClient(config);
        String modelId = "mo-reI5ejY5";
        try {
            System.out.println("\n--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DescribeModelRequest request = new DescribeModelRequest();
            request.setModelId(modelId);
            DescribeModelResponse response = client.model().describeModel(request);
            System.out.println("\u6a21\u578b\u8be6\u60c5\u83b7\u53d6\u6210\u529f\uff01");
            System.out.println("Request ID: " + response.getMetadata().getBceRequestId());
            System.out.println("\u6a21\u578bID: " + response.getId());
            System.out.println("\u6a21\u578b\u540d\u79f0: " + response.getName());
            System.out.println("\u6a21\u578b\u683c\u5f0f: " + response.getModelFormat());
            System.out.println("\u63cf\u8ff0: " + response.getDescription());
            System.out.println("\u6240\u6709\u8005: " + response.getOwnerName());
            System.out.println("\u53ef\u89c1\u8303\u56f4: " + response.getVisibilityScope());
            System.out.println("\u521b\u5efa\u65f6\u95f4: " + response.getCreatedAt());
            System.out.println("\u66f4\u65b0\u65f6\u95f4: " + response.getUpdatedAt());
            if (response.getVersionEntry() != null) {
                DescribeModelResponse.ModelVersionEntry versionEntry = response.getVersionEntry();
                System.out.println("\n\u6700\u65b0\u7248\u672c\u4fe1\u606f:");
                System.out.println("  \u7248\u672c\u53f7: " + versionEntry.getVersion());
                System.out.println("  \u7248\u672cID: " + versionEntry.getId());
                System.out.println("  \u6765\u6e90: " + versionEntry.getSource());
                System.out.println("  \u5b58\u50a8\u6876: " + versionEntry.getStorageBucket());
                System.out.println("  \u5b58\u50a8\u8def\u5f84: " + versionEntry.getStoragePath());
                System.out.println("  \u63cf\u8ff0: " + versionEntry.getDescription());
                System.out.println("  \u521b\u5efa\u7528\u6237: " + versionEntry.getCreateUserName());
                System.out.println("  \u521b\u5efa\u65f6\u95f4: " + versionEntry.getCreatedAt());
            }
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            ModelModule modelModule = client.model();
            DescribeModelResponse response2 = modelModule.describeModel(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u83b7\u53d6\u6a21\u578b\u8be6\u60c5\u6210\u529f\uff01");
            System.out.println("Request ID: " + response2.getMetadata().getBceRequestId());
            System.out.println("\u6a21\u578bID: " + response2.getId());
            System.out.println("\u6a21\u578b\u540d\u79f0: " + response2.getName());
        }
        catch (BceClientException e) {
            System.err.println("\u83b7\u53d6\u6a21\u578b\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

