/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.aihc.model;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.aihc.AihcClient;
import com.baidubce.services.aihc.model.model.DescribeModelsRequest;
import com.baidubce.services.aihc.model.model.DescribeModelsResponse;
import com.baidubce.services.aihc.modules.model.ModelModule;
import com.baidubce.util.JsonUtils;

public class ExampleDescribeModels {
    public static void main(String[] args) {
        String ak = System.getenv("BCE_ACCESS_KEY_ID") != null ? System.getenv("BCE_ACCESS_KEY_ID") : "Your AK";
        String sk = System.getenv("BCE_SECRET_ACCESS_KEY") != null ? System.getenv("BCE_SECRET_ACCESS_KEY") : "Your SK";
        String endpoint = "aihc.bj.baidubce.com";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        config.setProtocol(Protocol.HTTPS);
        AihcClient client = new AihcClient(config);
        DescribeModelsRequest request = new DescribeModelsRequest();
        request.setKeyword("test");
        request.setModelType("TENSORFLOW");
        request.setFramework("TF");
        request.setPageNumber(1);
        request.setPageSize(10);
        try {
            System.out.println("--- \u65b9\u5f0f1\uff1a\u4f20\u7edf\u8c03\u7528\u65b9\u5f0f ---");
            DescribeModelsResponse response = client.model().describeModels(request);
            System.out.println("\u6a21\u578b\u603b\u6570: " + (response.getTotalCount() != null ? response.getTotalCount() : 0));
            System.out.println("\u5f53\u524d\u9875\u6a21\u578b\u6570\u91cf: " + (response.getModels() != null ? response.getModels().size() : 0));
            System.out.println("\n--- \u65b9\u5f0f2\uff1a\u6a21\u5757\u5316\u8c03\u7528\u65b9\u5f0f ---");
            ModelModule modelModule = client.model();
            DescribeModelsResponse response2 = modelModule.describeModels(request);
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u67e5\u8be2\u6a21\u578b\u603b\u6570: " + (response2.getTotalCount() != null ? response2.getTotalCount() : 0));
            System.out.println("\u6a21\u5757\u5316\u65b9\u5f0f\u5f53\u524d\u9875\u6a21\u578b\u6570\u91cf: " + (response2.getModels() != null ? response2.getModels().size() : 0));
            if (response.getModels() != null && !response.getModels().isEmpty()) {
                System.out.println("\n=== \u6a21\u578b\u8be6\u7ec6\u4fe1\u606f ===");
                for (DescribeModelsResponse.Model model : response.getModels()) {
                    System.out.println("\u6a21\u578bID: " + model.getId());
                    System.out.println("\u6a21\u578b\u540d\u79f0: " + model.getName());
                    System.out.println("\u6a21\u578b\u7c7b\u578b: " + model.getModelType());
                    System.out.println("\u6846\u67b6: " + model.getFramework());
                    System.out.println("\u72b6\u6001: " + model.getStatus());
                    System.out.println("\u6240\u6709\u8005: " + model.getOwnerName());
                    System.out.println("\u521b\u5efa\u65f6\u95f4: " + model.getCreatedAt());
                    System.out.println("---");
                }
            }
            System.out.println("\n=== API\u8fd4\u56de\u7684JSON\u6570\u636e ===");
            String jsonResponse = JsonUtils.toJsonString(response);
            System.out.println(jsonResponse);
        }
        catch (BceClientException e) {
            System.out.println("API\u8c03\u7528\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

