/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.nat;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.Reservation;
import com.baidubce.services.bcc.model.TagModel;
import com.baidubce.services.nat.NatClient;
import com.baidubce.services.nat.NatClientConfiguration;
import com.baidubce.services.nat.model.CreateNatRequest;
import com.baidubce.services.nat.model.CreateNatResponse;
import java.util.ArrayList;
import java.util.Arrays;

public class ExampleCreateNat {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "bcc.bj.baidubce.com";
        NatClientConfiguration config = new NatClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        NatClient natClient = new NatClient(config);
        CreateNatRequest request = new CreateNatRequest();
        Reservation reservation = new Reservation();
        reservation.setReservationLength(1);
        reservation.setReservationTimeUnit("month");
        Billing billing = new Billing();
        billing.setPaymentTiming("Prepaid");
        billing.setReservation(reservation);
        request.setBilling(billing);
        request.setName("NatTest");
        request.setCuNum(2);
        request.setVpcId("vpc-a4sg6vsfzbra");
        request.setBindEips(Arrays.asList("100.88.3.255"));
        ArrayList<TagModel> tags = new ArrayList<TagModel>();
        tags.add(new TagModel().withTagKey("testKey").withTagValue("testValue"));
        request.setTags(tags);
        request.setResourceGroupId("RESG-xyfmAVnHGzK");
        request.setDeleteProtect(true);
        try {
            CreateNatResponse createNatResponse = natClient.createNat(request);
            System.out.println(createNatResponse);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

