/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.rocketmq;

import com.baidubce.BceClientConfiguration;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.rocketmq.RocketMQClient;
import com.baidubce.services.rocketmq.RocketMQClientConfiguration;
import com.baidubce.services.rocketmq.model.request.GetClusterRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterAclUserConfigsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterBrokerNodesRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterConsumerGroupsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterTopicsRequest;
import com.baidubce.services.rocketmq.model.response.GetClusterResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterAclUserConfigsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterBrokerNodesResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterConsumerGroupsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterTopicsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGetCluster {
    private static final Logger log = LoggerFactory.getLogger(ExampleGetCluster.class);

    public static void main(String[] args) {
        String endpoint = "rocketmq.bj.baidubce.com";
        String ak = "ak";
        String sk = "sk";
        String clusterId = "";
        BceClientConfiguration configuration = new RocketMQClientConfiguration().withProtocol(Protocol.HTTP).withCredentials(new DefaultBceCredentials(ak, sk)).withEndpoint(endpoint);
        RocketMQClient client = new RocketMQClient(configuration);
        ExampleGetCluster.getClusterDetail(client, clusterId);
        ExampleGetCluster.listClusterBrokerNodes(client, clusterId);
        ExampleGetCluster.listClusterTopics(client, clusterId);
        ExampleGetCluster.listClusterConsumerGroups(client, clusterId);
        ExampleGetCluster.listClusterAclUsers(client, clusterId);
    }

    static void getClusterDetail(RocketMQClient client, String clusterId) {
        GetClusterRequest request = new GetClusterRequest();
        request.setClusterId(clusterId);
        GetClusterResponse response = client.getCluster(request);
        log.info("GetClusters response: {}", (Object)response);
    }

    static void listClusterBrokerNodes(RocketMQClient client, String clusterId) {
        ListClusterBrokerNodesRequest request = new ListClusterBrokerNodesRequest();
        request.setClusterId(clusterId);
        ListClusterBrokerNodesResponse response = client.listClusterBrokerNodes(request);
        log.info("ListClusterBrokerNodes response: {}", (Object)response);
    }

    static void listClusterTopics(RocketMQClient client, String clusterId) {
        ListClusterTopicsRequest request = new ListClusterTopicsRequest();
        request.setClusterId(clusterId);
        ListClusterTopicsResponse response = client.listClusterTopics(request);
        log.info("ListClusterTopics response: {}", (Object)response);
    }

    static void listClusterConsumerGroups(RocketMQClient client, String clusterId) {
        ListClusterConsumerGroupsRequest request = new ListClusterConsumerGroupsRequest();
        request.setClusterId(clusterId);
        ListClusterConsumerGroupsResponse response = client.listClusterConsumerGroups(request);
        log.info("ListClusterConsumerGroups response: {}", (Object)response);
    }

    static void listClusterAclUsers(RocketMQClient client, String clusterId) {
        ListClusterAclUserConfigsRequest request = new ListClusterAclUserConfigsRequest();
        request.setClusterId(clusterId);
        ListClusterAclUserConfigsResponse response = client.listClusterAclUsers(request);
        log.info("ListClusterAclUsers response: {}", (Object)response);
    }
}

