/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.rocketmq;

import com.baidubce.BceClientConfiguration;
import com.baidubce.Protocol;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.rocketmq.RocketMQClient;
import com.baidubce.services.rocketmq.RocketMQClientConfiguration;
import com.baidubce.services.rocketmq.model.request.StartClusterRequest;
import com.baidubce.services.rocketmq.model.request.StopClusterRequest;
import com.baidubce.services.rocketmq.model.response.StartClusterResponse;
import com.baidubce.services.rocketmq.model.response.StopClusterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleOperateCluster {
    private static final Logger log = LoggerFactory.getLogger(ExampleOperateCluster.class);

    public static void main(String[] args) {
        String endpoint = "rocketmq.bj.baidubce.com";
        String ak = "ak";
        String sk = "sk";
        String clusterId = "";
        BceClientConfiguration configuration = new RocketMQClientConfiguration().withProtocol(Protocol.HTTP).withCredentials(new DefaultBceCredentials(ak, sk)).withEndpoint(endpoint);
        RocketMQClient client = new RocketMQClient(configuration);
        ExampleOperateCluster.startCluster(client, clusterId);
    }

    static void startCluster(RocketMQClient client, String clusterId) {
        StartClusterRequest request = new StartClusterRequest();
        request.setClusterId(clusterId);
        StartClusterResponse response = client.startCluster(request);
        log.info("StartCluster response: {}", (Object)response);
    }

    static void stopCluster(RocketMQClient client, String clusterId) {
        StopClusterRequest request = new StopClusterRequest();
        request.setClusterId(clusterId);
        StopClusterResponse response = client.stopCluster(request);
        log.info("StopCluster response: {}", (Object)response);
    }
}

