/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.aihc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.aihc.model.inference.AppChangeDetailRequest;
import com.baidubce.services.aihc.model.inference.AppChangeDetailResponse;
import com.baidubce.services.aihc.model.inference.AppDetailsRequest;
import com.baidubce.services.aihc.model.inference.AppDetailsResponse;
import com.baidubce.services.aihc.model.inference.BlockPodRequest;
import com.baidubce.services.aihc.model.inference.BlockPodResponse;
import com.baidubce.services.aihc.model.inference.CreateAppRequest;
import com.baidubce.services.aihc.model.inference.CreateAppResponse;
import com.baidubce.services.aihc.model.inference.DeleteAppRequest;
import com.baidubce.services.aihc.model.inference.DeleteAppResponse;
import com.baidubce.services.aihc.model.inference.DeletePodRequest;
import com.baidubce.services.aihc.model.inference.DeletePodResponse;
import com.baidubce.services.aihc.model.inference.ListAppRequest;
import com.baidubce.services.aihc.model.inference.ListAppResponse;
import com.baidubce.services.aihc.model.inference.ListChangeRequest;
import com.baidubce.services.aihc.model.inference.ListChangeResponse;
import com.baidubce.services.aihc.model.inference.ListPodRequest;
import com.baidubce.services.aihc.model.inference.ListPodResponse;
import com.baidubce.services.aihc.model.inference.ListResPoolBriefRequest;
import com.baidubce.services.aihc.model.inference.ListResPoolBriefResponse;
import com.baidubce.services.aihc.model.inference.ListStatsRequest;
import com.baidubce.services.aihc.model.inference.ListStatsResponse;
import com.baidubce.services.aihc.model.inference.PubAccessRequest;
import com.baidubce.services.aihc.model.inference.PubAccessResponse;
import com.baidubce.services.aihc.model.inference.ResPoolDetailRequest;
import com.baidubce.services.aihc.model.inference.ResPoolDetailResponse;
import com.baidubce.services.aihc.model.inference.ScaleAppRequest;
import com.baidubce.services.aihc.model.inference.ScaleAppResponse;
import com.baidubce.services.aihc.model.inference.UpdateAppRequest;
import com.baidubce.services.aihc.model.inference.UpdateAppResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class AihcInferenceClient
extends AbstractBceClient {
    private static final String APPPREFIX = "api/aihcpom/app";
    private static final String PODPREFIX = "api/aihcpom/pod";
    private static final String RESPOOLPREFIX = "api/aihcpom/respool";
    private static final String VERSION = "v1";
    private static HttpResponseHandler[] aihcInferenceHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AihcInferenceClient() {
        this(new BceClientConfiguration());
    }

    public AihcInferenceClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, aihcInferenceHandlers);
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String region, String prefix, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(prefix);
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        request.addHeader("X-Region", region);
        return request;
    }

    public CreateAppResponse createApp(CreateAppRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, APPPREFIX, "create");
        Validate.checkNotNull(request.getAppName(), "appName should not be null");
        Validate.checkNotNull(request.getChipType(), "chipType should not be null");
        if (request.getInsCount() <= 0) {
            throw new IllegalArgumentException("insCount should be > 0");
        }
        Validate.checkNotNull(request.getResPool(), "resPool should not be null");
        Validate.checkNotNull(request.getContainers(), "containers should not be null");
        Validate.checkNotNull(request.getAccess(), "access should not be null");
        Validate.checkNotNull(request.getLog(), "log should not be null");
        Validate.checkNotNull(request.getDeploy(), "deploy should not be null");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateAppResponse.class);
    }

    public ListAppResponse listApp(ListAppRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, APPPREFIX, "list");
        if (request.getKeyword() != null) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getPageNo() < 0) {
            throw new IllegalArgumentException("pageNo should be > 0");
        }
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize should be > 0");
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        if (request.getOrderBy() != null && request.getOrder() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListAppResponse.class);
    }

    public ListStatsResponse listStats(ListStatsRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, APPPREFIX, "stats");
        if (request.getAppIds().isEmpty()) {
            throw new IllegalArgumentException("appId should not be null");
        }
        String appIds = String.join((CharSequence)"#", request.getAppIds());
        internalRequest.addParameter("appIds", appIds);
        return this.invokeHttpClient(internalRequest, ListStatsResponse.class);
    }

    public AppDetailsResponse appDetails(AppDetailsRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, APPPREFIX, "details");
        Validate.checkStringNotEmpty(request.getAppId(), "appId should not be empty");
        internalRequest.addParameter("appId", request.getAppId());
        return this.invokeHttpClient(internalRequest, AppDetailsResponse.class);
    }

    public UpdateAppResponse updateApp(UpdateAppRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, APPPREFIX, "update");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        if (request.getShortDesc() != null) {
            internalRequest.addParameter("shortDesc", request.getShortDesc());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateAppResponse.class);
    }

    public ScaleAppResponse scaleApp(ScaleAppRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, APPPREFIX, "scale");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        if (request.getInsCount() < 0) {
            throw new IllegalArgumentException("insCount should be >= 0");
        }
        internalRequest.addParameter("appId", request.getAppId());
        internalRequest.addParameter("insCount", String.valueOf(request.getInsCount()));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ScaleAppResponse.class);
    }

    public PubAccessResponse pubAccess(PubAccessRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, APPPREFIX, "pubaccess");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        internalRequest.addParameter("publicAccess", String.valueOf(request.isPublicAccess()));
        if (request.getEip() != null) {
            internalRequest.addParameter("eip", request.getEip());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, PubAccessResponse.class);
    }

    public ListChangeResponse listChange(ListChangeRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, APPPREFIX, "listchange");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        internalRequest.addParameter("changeType", String.valueOf(request.getChangeType()));
        if (request.getOrder() != null) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (request.getPageNo() < 0) {
            throw new IllegalArgumentException("pageNo should be > 0");
        }
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize should be > 0");
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        if (request.getOrderBy() != null && request.getOrder() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListChangeResponse.class);
    }

    public AppChangeDetailResponse appChangeDetail(AppChangeDetailRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, APPPREFIX, "changedetail");
        Validate.checkNotNull(request.getChangeId(), "changeId should not be null");
        internalRequest.addParameter("changeId", request.getChangeId());
        return this.invokeHttpClient(internalRequest, AppChangeDetailResponse.class);
    }

    public DeleteAppResponse deleteApp(DeleteAppRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, APPPREFIX, "delete");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteAppResponse.class);
    }

    public ListPodResponse listPod(ListPodRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, PODPREFIX, "list");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        return this.invokeHttpClient(internalRequest, ListPodResponse.class);
    }

    public BlockPodResponse blockPod(BlockPodRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, PODPREFIX, "block");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        Validate.checkNotNull(request.getInsID(), "insID should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        internalRequest.addParameter("insID", request.getInsID());
        internalRequest.addParameter("block", String.valueOf(request.isBlock()));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BlockPodResponse.class);
    }

    public DeletePodResponse deletePod(DeletePodRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, region, PODPREFIX, "delete");
        Validate.checkNotNull(request.getAppId(), "appId should not be null");
        Validate.checkNotNull(request.getInsID(), "insID should not be null");
        internalRequest.addParameter("appId", request.getAppId());
        internalRequest.addParameter("insID", request.getInsID());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeletePodResponse.class);
    }

    public ListResPoolBriefResponse listResPoolBrief(ListResPoolBriefRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, RESPOOLPREFIX, "listbrief");
        if (request.getPageNo() < 0) {
            throw new IllegalArgumentException("pageNo should be > 0");
        }
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize should be > 0");
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, ListResPoolBriefResponse.class);
    }

    public ResPoolDetailResponse resPoolDetail(ResPoolDetailRequest request, String region) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, region, RESPOOLPREFIX, "detail");
        Validate.checkNotNull(request.getResPoolId(), "resPoolId should not be null");
        internalRequest.addParameter("resPoolId", request.getResPoolId());
        return this.invokeHttpClient(internalRequest, ResPoolDetailResponse.class);
    }
}

