/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.aihc.core;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public abstract class AihcClientCore
extends AbstractBceClient {
    protected static final String APIPREFIX = "/";
    protected static final String VERSION = "v2";
    private static HttpResponseHandler[] aihcHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AihcClientCore() {
        this(new BceClientConfiguration());
    }

    public AihcClientCore(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, aihcHandlers);
    }

    @Override
    public String computeServiceId() {
        return "aihc";
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.GET) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    protected InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String prefix, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(prefix);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        request.addHeader("version", VERSION);
        return request;
    }

    protected InternalRequest createAihcRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String action) {
        InternalRequest internalRequest = this.createRequest(bceRequest, httpMethod, APIPREFIX, new String[0]);
        internalRequest.addParameter("action", action);
        return internalRequest;
    }
}

