/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.aihc.modules.dataset;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.aihc.core.AihcClientCore;
import com.baidubce.services.aihc.model.dataset.CreateDatasetRequest;
import com.baidubce.services.aihc.model.dataset.CreateDatasetResponse;
import com.baidubce.services.aihc.model.dataset.CreateDatasetVersionRequest;
import com.baidubce.services.aihc.model.dataset.CreateDatasetVersionResponse;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetRequest;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetResponse;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetVersionRequest;
import com.baidubce.services.aihc.model.dataset.DeleteDatasetVersionResponse;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetResponse;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionResponse;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionsRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetVersionsResponse;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetsRequest;
import com.baidubce.services.aihc.model.dataset.DescribeDatasetsResponse;
import com.baidubce.services.aihc.model.dataset.ModifyDatasetRequest;
import com.baidubce.services.aihc.model.dataset.ModifyDatasetResponse;
import com.baidubce.services.aihc.modules.dataset.DatasetModule;

public class DatasetModuleImpl
extends AihcClientCore
implements DatasetModule {
    public DatasetModuleImpl() {
    }

    public DatasetModuleImpl(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.POST, "CreateDataset");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDatasetResponse.class);
    }

    @Override
    public ModifyDatasetResponse modifyDataset(ModifyDatasetRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.POST, "ModifyDataset");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ModifyDatasetResponse.class);
    }

    @Override
    public CreateDatasetVersionResponse createDatasetVersion(CreateDatasetVersionRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.POST, "CreateDatasetVersion");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDatasetVersionResponse.class);
    }

    @Override
    public DescribeDatasetsResponse describeDatasets(DescribeDatasetsRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.GET, "DescribeDatasets");
        if (request.getKeyword() != null) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getStorageType() != null) {
            internalRequest.addParameter("storageType", request.getStorageType());
        }
        if (request.getStorageInstances() != null) {
            internalRequest.addParameter("storageInstances", request.getStorageInstances());
        }
        if (request.getImportFormat() != null) {
            internalRequest.addParameter("importFormat", request.getImportFormat());
        }
        if (request.getPageNumber() != null && request.getPageNumber() > 0) {
            internalRequest.addParameter("pageNumber", String.valueOf(request.getPageNumber()));
        }
        if (request.getPageSize() != null && request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, DescribeDatasetsResponse.class);
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.GET, "DescribeDataset");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        return this.invokeHttpClient(internalRequest, DescribeDatasetResponse.class);
    }

    @Override
    public DescribeDatasetVersionsResponse describeDatasetVersions(DescribeDatasetVersionsRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.GET, "DescribeDatasetVersions");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        if (request.getPageNumber() != null && request.getPageNumber() > 0) {
            internalRequest.addParameter("pageNumber", String.valueOf(request.getPageNumber()));
        }
        if (request.getPageSize() != null && request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, DescribeDatasetVersionsResponse.class);
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.POST, "DeleteDataset");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteDatasetResponse.class);
    }

    @Override
    public DeleteDatasetVersionResponse deleteDatasetVersion(DeleteDatasetVersionRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.POST, "DeleteDatasetVersion");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        if (request.getVersionId() != null) {
            internalRequest.addParameter("versionId", request.getVersionId());
        }
        this.fillPayload(internalRequest, request);
        System.out.println("DeleteDatasetVersionRequest: " + internalRequest);
        return this.invokeHttpClient(internalRequest, DeleteDatasetVersionResponse.class);
    }

    @Override
    public DescribeDatasetVersionResponse describeDatasetVersion(DescribeDatasetVersionRequest request) {
        InternalRequest internalRequest = this.createAihcRequest(request, HttpMethodName.GET, "DescribeDatasetVersion");
        if (request.getDatasetId() != null) {
            internalRequest.addParameter("datasetId", request.getDatasetId());
        }
        if (request.getVersionId() != null) {
            internalRequest.addParameter("versionId", request.getVersionId());
        }
        return this.invokeHttpClient(internalRequest, DescribeDatasetVersionResponse.class);
    }
}

