/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bec;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.BecClientConfiguration;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupBackendPolicyRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupBackendPolicyResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbIpGroupResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupMemberRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupMemberResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupPortRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupPortResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.CreateBecAppBlbServerGroupResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupBackendPoliciesRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupBackendPoliciesResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbIpGroupResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupPortRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupPortResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.DeleteBecAppBlbServerGroupResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupBackendPoliciesRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupBackendPoliciesResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupsRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbIpGroupsResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupMountedMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupMountedMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupUnmountedMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupUnmountedMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupsRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.GetBecAppBlbServerGroupsResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupBackendPolicyRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupBackendPolicyResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbIpGroupResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupMembersRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupMembersResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupPortRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupPortResponse;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupRequest;
import com.baidubce.services.bec.model.appblbv2.backendbind.UpdateBecAppBlbServerGroupResponse;
import com.baidubce.services.bec.model.appblbv2.instance.CreateBecAppBlbRequest;
import com.baidubce.services.bec.model.appblbv2.instance.CreateBecAppBlbResponse;
import com.baidubce.services.bec.model.appblbv2.instance.DeleteBecAppBlbRequest;
import com.baidubce.services.bec.model.appblbv2.instance.DeleteBecAppBlbResponse;
import com.baidubce.services.bec.model.appblbv2.instance.GetBecAppBlbRequest;
import com.baidubce.services.bec.model.appblbv2.instance.GetBecAppBlbResponse;
import com.baidubce.services.bec.model.appblbv2.instance.GetBecAppBlbsRequest;
import com.baidubce.services.bec.model.appblbv2.instance.GetBecAppBlbsResponse;
import com.baidubce.services.bec.model.appblbv2.instance.UpdateBecAppBlbRequest;
import com.baidubce.services.bec.model.appblbv2.instance.UpdateBecAppBlbResponse;
import com.baidubce.services.bec.model.appblbv2.listener.BatchDeleteBecAppBlbListenersRequest;
import com.baidubce.services.bec.model.appblbv2.listener.BatchDeleteBecAppBlbListenersResponse;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbListenerPoliciesRequest;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbListenerPoliciesResponse;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbTCPListenerRequest;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbTCPListenerResponse;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbUDPListenerRequest;
import com.baidubce.services.bec.model.appblbv2.listener.CreateBecAppBlbUDPListenerResponse;
import com.baidubce.services.bec.model.appblbv2.listener.DeleteBecAppBlbListenerPoliciesRequest;
import com.baidubce.services.bec.model.appblbv2.listener.DeleteBecAppBlbListenerPoliciesResponse;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbListenerPoliciesRequest;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbListenerPoliciesResponse;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbTCPListenersRequest;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbTCPListenersResponse;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbUDPListenersRequest;
import com.baidubce.services.bec.model.appblbv2.listener.GetBecAppBlbUDPListenersResponse;
import com.baidubce.services.bec.model.appblbv2.listener.UpdateBecAppBlbTCPListenerRequest;
import com.baidubce.services.bec.model.appblbv2.listener.UpdateBecAppBlbTCPListenerResponse;
import com.baidubce.services.bec.model.appblbv2.listener.UpdateBecAppBlbUDPListenerRequest;
import com.baidubce.services.bec.model.appblbv2.listener.UpdateBecAppBlbUDPListenerResponse;
import com.baidubce.services.bec.model.blb.CreateBecBlbBindingRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbBindingResponse;
import com.baidubce.services.bec.model.blb.CreateBecBlbMonitorPortRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbMonitorPortResponse;
import com.baidubce.services.bec.model.blb.CreateBecBlbRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbResponse;
import com.baidubce.services.bec.model.blb.DeleteBecBlbRequest;
import com.baidubce.services.bec.model.blb.DeleteBecBlbResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendBindingStsListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendBindingStsListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendPodListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendPodListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBindingPodListWithStsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBindingPodListWithStsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbInstanceRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbInstanceResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortDetailsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortDetailsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbResourceMetricsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbResourceMetricsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbsResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbBindPodWeightRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbBindPodWeightResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbMonitorPortRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbMonitorPortResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbResponse;
import com.baidubce.services.bec.model.handler.BecHttpResponseHandler;
import com.baidubce.services.bec.model.network.acl.BatchCreateBecAclRulesRequest;
import com.baidubce.services.bec.model.network.acl.BatchCreateBecAclRulesResponse;
import com.baidubce.services.bec.model.network.acl.BatchDeleteBecAclRulesRequest;
import com.baidubce.services.bec.model.network.acl.BatchDeleteBecAclRulesResponse;
import com.baidubce.services.bec.model.network.acl.GetBecAclRequest;
import com.baidubce.services.bec.model.network.acl.GetBecAclResponse;
import com.baidubce.services.bec.model.network.acl.GetBecAclsRequest;
import com.baidubce.services.bec.model.network.acl.GetBecAclsResponse;
import com.baidubce.services.bec.model.network.acl.UpdateBecAclRequest;
import com.baidubce.services.bec.model.network.acl.UpdateBecAclResponse;
import com.baidubce.services.bec.model.network.acl.UpdateBecAclRuleRequest;
import com.baidubce.services.bec.model.network.acl.UpdateBecAclRuleResponse;
import com.baidubce.services.bec.model.network.nat.dnatrule.BatchCreateBecDnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.dnatrule.BatchCreateBecDnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.dnatrule.BatchDeleteBecDnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.dnatrule.BatchDeleteBecDnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.dnatrule.CreateBecDnatRuleRequest;
import com.baidubce.services.bec.model.network.nat.dnatrule.CreateBecDnatRuleResponse;
import com.baidubce.services.bec.model.network.nat.dnatrule.GetBecDnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.dnatrule.GetBecDnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.dnatrule.UpdateBecDnatRuleRequest;
import com.baidubce.services.bec.model.network.nat.dnatrule.UpdateBecDnatRuleResponse;
import com.baidubce.services.bec.model.network.nat.instance.BatchCreateBecNatsRequest;
import com.baidubce.services.bec.model.network.nat.instance.BatchCreateBecNatsResponse;
import com.baidubce.services.bec.model.network.nat.instance.BatchDeleteBecNatsRequest;
import com.baidubce.services.bec.model.network.nat.instance.BatchDeleteBecNatsResponse;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatMetricsRequest;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatMetricsResponse;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatRequest;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatResponse;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatsRequest;
import com.baidubce.services.bec.model.network.nat.instance.GetBecNatsResponse;
import com.baidubce.services.bec.model.network.nat.instance.UpdateBecNatBandwidthRequest;
import com.baidubce.services.bec.model.network.nat.instance.UpdateBecNatBandwidthResponse;
import com.baidubce.services.bec.model.network.nat.instance.UpdateBecNatRequest;
import com.baidubce.services.bec.model.network.nat.instance.UpdateBecNatResponse;
import com.baidubce.services.bec.model.network.nat.snatrule.BatchCreateBecSnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.snatrule.BatchCreateBecSnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.snatrule.BatchDeleteBecSnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.snatrule.BatchDeleteBecSnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.snatrule.CreateBecSnatRuleRequest;
import com.baidubce.services.bec.model.network.nat.snatrule.CreateBecSnatRuleResponse;
import com.baidubce.services.bec.model.network.nat.snatrule.GetBecSnatRulesRequest;
import com.baidubce.services.bec.model.network.nat.snatrule.GetBecSnatRulesResponse;
import com.baidubce.services.bec.model.network.nat.snatrule.UpdateBecSnatRuleRequest;
import com.baidubce.services.bec.model.network.nat.snatrule.UpdateBecSnatRuleResponse;
import com.baidubce.services.bec.model.network.route.CreateBecRouteRuleRequest;
import com.baidubce.services.bec.model.network.route.CreateBecRouteRuleResponse;
import com.baidubce.services.bec.model.network.route.DeleteBecRouteRuleRequest;
import com.baidubce.services.bec.model.network.route.DeleteBecRouteRuleResponse;
import com.baidubce.services.bec.model.network.route.GetBecRouteRulesRequest;
import com.baidubce.services.bec.model.network.route.GetBecRouteRulesResponse;
import com.baidubce.services.bec.model.network.route.GetBecRouteTableRequest;
import com.baidubce.services.bec.model.network.route.GetBecRouteTableResponse;
import com.baidubce.services.bec.model.network.route.GetBecRouteTablesRequest;
import com.baidubce.services.bec.model.network.route.GetBecRouteTablesResponse;
import com.baidubce.services.bec.model.network.route.UpdateBecRouteTableRequest;
import com.baidubce.services.bec.model.network.route.UpdateBecRouteTableResponse;
import com.baidubce.services.bec.model.network.securitygroup.BatchCreateBecSgRulesRequest;
import com.baidubce.services.bec.model.network.securitygroup.BatchCreateBecSgRulesResponse;
import com.baidubce.services.bec.model.network.securitygroup.BatchDeleteBecSgRulesRequest;
import com.baidubce.services.bec.model.network.securitygroup.BatchDeleteBecSgRulesResponse;
import com.baidubce.services.bec.model.network.securitygroup.CreateBecSecurityGroupRequest;
import com.baidubce.services.bec.model.network.securitygroup.CreateBecSecurityGroupResponse;
import com.baidubce.services.bec.model.network.securitygroup.DeleteBecSecurityGroupRequest;
import com.baidubce.services.bec.model.network.securitygroup.DeleteBecSecurityGroupResponse;
import com.baidubce.services.bec.model.network.securitygroup.GetBecSecurityGroupRequest;
import com.baidubce.services.bec.model.network.securitygroup.GetBecSecurityGroupResponse;
import com.baidubce.services.bec.model.network.securitygroup.GetBecSecurityGroupsRequest;
import com.baidubce.services.bec.model.network.securitygroup.GetBecSecurityGroupsResponse;
import com.baidubce.services.bec.model.network.securitygroup.UpdateBecSecurityGroupRequest;
import com.baidubce.services.bec.model.network.securitygroup.UpdateBecSecurityGroupResponse;
import com.baidubce.services.bec.model.network.securitygroup.UpdateBecSecurityGroupRuleRequest;
import com.baidubce.services.bec.model.network.securitygroup.UpdateBecSecurityGroupRuleResponse;
import com.baidubce.services.bec.model.network.subnet.CreateBecSubnetRequest;
import com.baidubce.services.bec.model.network.subnet.CreateBecSubnetResponse;
import com.baidubce.services.bec.model.network.subnet.DeleteBecSubnetRequest;
import com.baidubce.services.bec.model.network.subnet.DeleteBecSubnetResponse;
import com.baidubce.services.bec.model.network.subnet.GetBecSubnetRequest;
import com.baidubce.services.bec.model.network.subnet.GetBecSubnetResponse;
import com.baidubce.services.bec.model.network.subnet.GetBecSubnetsRequest;
import com.baidubce.services.bec.model.network.subnet.GetBecSubnetsResponse;
import com.baidubce.services.bec.model.network.subnet.UpdateBecSubnetRequest;
import com.baidubce.services.bec.model.network.subnet.UpdateBecSubnetResponse;
import com.baidubce.services.bec.model.network.vpc.CreateBecVpcRequest;
import com.baidubce.services.bec.model.network.vpc.CreateBecVpcResponse;
import com.baidubce.services.bec.model.network.vpc.DeleteBecVpcRequest;
import com.baidubce.services.bec.model.network.vpc.DeleteBecVpcResponse;
import com.baidubce.services.bec.model.network.vpc.GetBecVpcRequest;
import com.baidubce.services.bec.model.network.vpc.GetBecVpcResponse;
import com.baidubce.services.bec.model.network.vpc.GetBecVpcsRequest;
import com.baidubce.services.bec.model.network.vpc.GetBecVpcsResponse;
import com.baidubce.services.bec.model.network.vpc.UpdateBecVpcRequest;
import com.baidubce.services.bec.model.network.vpc.UpdateBecVpcResponse;
import com.baidubce.services.bec.model.overview.GetBecContainerMetricsRequest;
import com.baidubce.services.bec.model.overview.GetBecContainerMetricsResponse;
import com.baidubce.services.bec.model.overview.GetBecContainerSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecContainerSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecResourceSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecResourceSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecVMSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecVMSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecVmMetricsRequest;
import com.baidubce.services.bec.model.overview.GetBecVmMetricsResponse;
import com.baidubce.services.bec.model.overview.GetBecVmNodeLevelMetricsRequest;
import com.baidubce.services.bec.model.overview.GetBecVmNodeLevelMetricsResponse;
import com.baidubce.services.bec.model.resource.ListBecPassThroughDiskPackagesRequest;
import com.baidubce.services.bec.model.resource.ListBecPassThroughDiskPackagesResponse;
import com.baidubce.services.bec.model.resource.ListBecServicePackagesRequest;
import com.baidubce.services.bec.model.resource.ListBecServicePackagesResponse;
import com.baidubce.services.bec.model.vm.deployset.CreateBecDeploySetRequest;
import com.baidubce.services.bec.model.vm.deployset.CreateBecDeploySetResponse;
import com.baidubce.services.bec.model.vm.deployset.DeleteBecDeploySetInstancesRequest;
import com.baidubce.services.bec.model.vm.deployset.DeleteBecDeploySetInstancesResponse;
import com.baidubce.services.bec.model.vm.deployset.DeleteBecDeploySetRequest;
import com.baidubce.services.bec.model.vm.deployset.DeleteBecDeploySetResponse;
import com.baidubce.services.bec.model.vm.deployset.GetBecDeploySetRequest;
import com.baidubce.services.bec.model.vm.deployset.GetBecDeploySetResponse;
import com.baidubce.services.bec.model.vm.deployset.GetBecDeploySetsRequest;
import com.baidubce.services.bec.model.vm.deployset.GetBecDeploySetsResponse;
import com.baidubce.services.bec.model.vm.deployset.UpdateBecDeploySetInstanceRequest;
import com.baidubce.services.bec.model.vm.deployset.UpdateBecDeploySetInstanceResponse;
import com.baidubce.services.bec.model.vm.deployset.UpdateBecDeploySetRequest;
import com.baidubce.services.bec.model.vm.deployset.UpdateBecDeploySetResponse;
import com.baidubce.services.bec.model.vm.image.BatchDeleteBecVmImageRequest;
import com.baidubce.services.bec.model.vm.image.BatchDeleteBecVmImageResponse;
import com.baidubce.services.bec.model.vm.image.CreateBecVmImageRequest;
import com.baidubce.services.bec.model.vm.image.CreateBecVmImageResponse;
import com.baidubce.services.bec.model.vm.image.GetBecVmImagesRequest;
import com.baidubce.services.bec.model.vm.image.GetBecVmImagesResponse;
import com.baidubce.services.bec.model.vm.image.UpdateBecVmImageRequest;
import com.baidubce.services.bec.model.vm.image.UpdateBecVmImageResponse;
import com.baidubce.services.bec.model.vm.instance.DeleteBecVmInstanceRequest;
import com.baidubce.services.bec.model.vm.instance.DeleteBecVmInstanceResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecNodeVmInstanceListRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecNodeVmInstanceListResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVirtualMachineRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVirtualMachineResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmConfigRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmConfigResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceListRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceListResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceMetricsRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceMetricsResponse;
import com.baidubce.services.bec.model.vm.instance.OperateBecVmDeploymentRequest;
import com.baidubce.services.bec.model.vm.instance.OperateBecVmDeploymentResponse;
import com.baidubce.services.bec.model.vm.instance.ReinstallBecVmInstanceRequest;
import com.baidubce.services.bec.model.vm.instance.ReinstallBecVmInstanceResponse;
import com.baidubce.services.bec.model.vm.instance.UpdateBecVmDeploymentRequest;
import com.baidubce.services.bec.model.vm.instance.UpdateBecVmDeploymentResponse;
import com.baidubce.services.bec.model.vm.service.BecVmServiceActionRequest;
import com.baidubce.services.bec.model.vm.service.BecVmServiceActionResponse;
import com.baidubce.services.bec.model.vm.service.CreateBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.CreateBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.DelBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.DelBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceMetricsRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceMetricsResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServicesRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServicesResponse;
import com.baidubce.services.bec.model.vm.service.UpdateBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.UpdateBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.template.CreateBecVmTemplateRequest;
import com.baidubce.services.bec.model.vm.template.CreateBecVmTemplateResponse;
import com.baidubce.services.bec.model.vm.template.GetBecVmTemplateListRequest;
import com.baidubce.services.bec.model.vm.template.GetBecVmTemplateListResponse;
import com.baidubce.services.bec.model.vm.template.GetBecVmTemplateRequest;
import com.baidubce.services.bec.model.vm.template.GetBecVmTemplateResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BecClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String VERSION_2 = "v2";
    private static final String OVERVIEW = "overview";
    private static final String SUMMARY = "summary";
    private static final String CONTAINER = "container";
    private static final String BLB_PREFIX = "blb";
    private static final String LB_PREFIX = "lb";
    private static final String VM_PREFIX = "vm";
    private static final String NODE_PREFIX = "node";
    private static final String DEPLOY_SET_PREFIX = "deployset";
    private static final String VPC_PREFIX = "vpc";
    private static final String SUBNET_PREFIX = "subnet";
    private static final String SECURITY_GROUP_PREFIX = "securityGroup";
    private static final String ROUTE_PREFIX = "route";
    private static final String APP_BLB_PREFIX = "appblb";
    private static final String NAT_PREFIX = "nat";
    private static final String SERVICE = "service";
    private static final String INSTANCE = "instance";
    private static final String TEMPLATE = "template";
    private static final String IMAGE = "image";
    private static final String METRICS = "metrics";
    private static final String ACL = "acl";
    private static final String RULE = "rule";
    private static final String BATCH = "batch";
    private static final String DELETE = "delete";
    private static final String ADD = "add";
    private static final String UPDATE = "update";
    private static final String DETAIL = "detail";
    private static final String REGIONS = "regions";
    private static final String SERVICE_PROVIDER = "sps";
    private static final String CITIES = "cities";
    private static final String SYSTEM = "system";
    private static final String CONFIG = "config";
    private static final String REINSTALL = "reinstall";
    private static final String MONITOR = "monitor";
    private static final String RESOURCE = "resource";
    private static final String PACKAGE = "package";
    private static final String DISK = "disk";
    private static final String PASS_THROUGH = "passthrough";
    private static final String BINDED = "binded";
    private static final String BINDING = "binding";
    private static final String BINDINGPOD = "bindingpod";
    private static final String PORT = "port";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String CREATE = "create";
    private static final String LIST = "list";
    private static final String DEL_RELATION = "delRelation";
    private static final String UPDATE_RELATION = "updateRelation";
    private static final String TCP_LISTENER = "TCPlistener";
    private static final String UDP_LISTENER = "UDPlistener";
    private static final String POLICYS = "policys";
    private static final String LISTENER = "listener";
    private static final String IP_GROUP = "ipgroup";
    private static final String UPDATE_BANDWIDTH = "updateBandwidth";
    private static final String BACKEND_POLICY = "backendpolicy";
    private static final String MEMBER = "member";
    private static final String SNAT_RULE = "snatRule";
    private static final String DNAT_RULE = "dnatRule";
    private static final String BATCH_CREATE = "batchCreate";
    private static final String BATCH_DELETE = "batchdelete";
    private static final String APP_SERVER_GROUP = "appservergroup";
    private static final String APP_SERVER_GROUP_PORT = "appservergroupport";
    private static final String BLBRS = "blbrs";
    private static final String SG_ID = "sgId";
    private static final String BLBRSUNMOUNT = "blbrsunmount";
    private static final String BLBRSMOUNT = "blbrsmount";
    private static final String EXACTLY_MATCH = "exactlyMatch";
    private static final String NAME = "name";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE = "offsetInSeconds should not be null.";
    private static final String BLB_ID_MESSAGE_KEY = "blbId";
    private static final String SG_ID_MESSAGE_KEY = "sgId";
    private static final String BLB_TYPE_MESSAGE_KEY = "type";
    private static final String IP_TYPE_MESSAGE_KEY = "ipType";
    private static final String VM_SERVICE_ID_MESSAGE_KEY = "serviceId";
    private static final String VM_ID_MESSAGE_KEY = "vmId";
    private static final String TEMPLATE_ID_MESSAGE_KEY = "templateId";
    private static final String VM_INSTANCE_REGION_MESSAGE_KEY = "region";
    private static final String VM_INSTANCE_SPS_MESSAGE_KEY = "serviceProvider";
    private static final String VM_INSTANCE_CITY_MESSAGE_KEY = "city";
    private static final String VM_ACTION_MESSAGE_KEY = "action";
    private static final String IMAGE_ID_MESSAGE_KEY = "imageId";
    private static final String IMAGE_ID_LIST_MESSAGE_KEY = "imageIdList";
    private static final String METRICS_TYPE_MESSAGE_KEY = "metricsType";
    private static final String START_MESSAGE_KEY = "start";
    private static final String END_MESSAGE_KEY = "end";
    private static final String DEPLOY_SET_ID_MESSAGE_KEY = "deploySetId";
    private static final String VPC_ID_MESSAGE_KEY = "vpcId";
    private static final String SUBNET_ID_MESSAGE_KEY = "subnetId";
    private static final String INSTANCE_ID_MESSAGE_KEY = "instanceId";
    private static final String SECURITY_GROUP_ID_MESSAGE_KEY = "securityGroupId";
    private static final String SECURITY_GROUP_RULE_ID_MESSAGE_KEY = "securityGroupRuleId";
    private static final String ROUTE_TABLE_ID_MESSAGE_KEY = "tableId";
    private static final String ACL_RULE_ID_MESSAGE_KEY = "aclRuleId";
    private static final String ROUTE_RULE_ID_MESSAGE_KEY = "ruleId";
    private static final String ACL_ID_MESSAGE_KEY = "aclId";
    private static final String NAT_ID_MESSAGE_KEY = "natId";
    private static final String RULE_ID_MESSAGE_KEY = "ruleId";
    private static final String IP_GROUP_ID_MESSAGE_KEY = "ipGroupId";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] bec_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BecHttpResponseHandler(), new BceJsonResponseHandler()};

    public BecClient() {
        this(new BecClientConfiguration());
    }

    public BecClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, bec_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        return this.commonRequestProcess(bceRequest, httpMethod, path);
    }

    private InternalRequest createRequestV2(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION_2);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        return this.commonRequestProcess(bceRequest, httpMethod, path);
    }

    private InternalRequest commonRequestProcess(AbstractBceRequest bceRequest, HttpMethodName httpMethod, List<String> path) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateBecVmServiceResponse createBecVmService(CreateBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VM_PREFIX, SERVICE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVmServiceResponse.class);
    }

    public CreateBecVmServiceResponse createBecVmServiceInstances(CreateBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VM_PREFIX, SERVICE, request.getServiceId(), INSTANCE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVmServiceResponse.class);
    }

    public GetBecVmServicesResponse getBecVmServices(GetBecVmServicesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, SERVICE);
        if (StringUtils.isNotEmpty((CharSequence)request.getKeywordType())) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmServicesResponse.class);
    }

    public UpdateBecVmServiceResponse updateBecVmService(UpdateBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, SERVICE, request.getServiceId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVmServiceResponse.class);
    }

    public GetBecVmServiceResponse getBecVmService(GetBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, SERVICE, request.getServiceId());
        return this.invokeHttpClient(internalRequest, GetBecVmServiceResponse.class);
    }

    public BecVmServiceActionResponse becVmServiceAction(BecVmServiceActionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAction(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ACTION_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, SERVICE, request.getServiceId(), request.getAction());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        return this.invokeHttpClient(internalRequest, BecVmServiceActionResponse.class);
    }

    public DelBecVmServiceResponse deleteBecVmService(DelBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VM_PREFIX, SERVICE, request.getServiceId());
        return this.invokeHttpClient(internalRequest, DelBecVmServiceResponse.class);
    }

    public GetBecVmServiceMetricsResponse getBecVmServiceMetrics(GetBecVmServiceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, SERVICE, VM_PREFIX, request.getServiceId());
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceId())) {
            internalRequest.addParameter(VM_SERVICE_ID_MESSAGE_KEY, request.getServiceId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds();
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(start));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        if (request.getStepInMin() != null && request.getStepInMin() > 0) {
            internalRequest.addParameter("stepInMin", String.valueOf(request.getStepInMin()));
        }
        return this.invokeHttpClient(internalRequest, GetBecVmServiceMetricsResponse.class);
    }

    public GetBecVmInstanceListResponse getBecVmInstanceList(GetBecVmInstanceListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrder())) {
                internalRequest.addParameter("order", request.getListRequest().getOrder());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrderBy())) {
                internalRequest.addParameter("orderBy", request.getListRequest().getOrderBy());
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecVmInstanceListResponse.class);
    }

    public GetBecNodeVmInstanceListResponse getBecNodeVmInstanceList(GetBecNodeVmInstanceListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_REGION_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getServiceProvider(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_SPS_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getCity(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_CITY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, REGIONS, request.getRegion(), SERVICE_PROVIDER, request.getServiceProvider(), CITIES, request.getCity());
        return this.invokeHttpClient(internalRequest, GetBecNodeVmInstanceListResponse.class);
    }

    public GetBecVirtualMachineResponse getBecVmInstance(GetBecVirtualMachineRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, request.getVmID());
        return this.invokeHttpClient(internalRequest, GetBecVirtualMachineResponse.class);
    }

    public DeleteBecVmInstanceResponse deleteBecVmInstance(DeleteBecVmInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VM_PREFIX, INSTANCE, request.getVmID());
        return this.invokeHttpClient(internalRequest, DeleteBecVmInstanceResponse.class);
    }

    public UpdateBecVmDeploymentResponse updateBecVmDeployment(UpdateBecVmDeploymentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVmDeploymentResponse.class);
    }

    public ReinstallBecVmInstanceResponse reinstallBecVmInstance(ReinstallBecVmInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID(), SYSTEM, REINSTALL);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ReinstallBecVmInstanceResponse.class);
    }

    public OperateBecVmDeploymentResponse operateBecVmDeployment(OperateBecVmDeploymentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAction(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ACTION_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID(), request.getAction());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, OperateBecVmDeploymentResponse.class);
    }

    public GetBecVmInstanceMetricsResponse getBecVmInstanceMetrics(GetBecVmInstanceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, VM_PREFIX, request.getVmId());
        if (StringUtils.isNotEmpty((CharSequence)request.getVmId())) {
            internalRequest.addParameter(VM_ID_MESSAGE_KEY, request.getVmId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds();
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(start));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        if (request.getStepInMin() != null && request.getStepInMin() > 0) {
            internalRequest.addParameter("stepInMin", String.valueOf(request.getStepInMin()));
        }
        return this.invokeHttpClient(internalRequest, GetBecVmInstanceMetricsResponse.class);
    }

    public GetBecVmNodeLevelMetricsResponse getVmNodeMetrics(GetBecVmNodeLevelMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_REGION_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getCity(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_CITY_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getServiceProvider(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_SPS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, OVERVIEW, VM_PREFIX, NODE_PREFIX, request.getType());
        if (request.getStart() > 0L && request.getEnd() > 0L) {
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(request.getStart()));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(request.getEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_CITY_MESSAGE_KEY, request.getCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_REGION_MESSAGE_KEY, request.getRegion());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getNetwork())) {
            internalRequest.addParameter("network", request.getNetwork());
        }
        if (request.getStepInMin() != null && request.getStepInMin() > 0) {
            internalRequest.addParameter("stepInMin", String.valueOf(request.getStepInMin()));
        }
        return this.invokeHttpClient(internalRequest, GetBecVmNodeLevelMetricsResponse.class);
    }

    public GetBecVmConfigResponse getBecVmConfig(GetBecVmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, request.getVmID(), CONFIG);
        return this.invokeHttpClient(internalRequest, GetBecVmConfigResponse.class);
    }

    public CreateBecVmTemplateResponse createBecVmTemplate(CreateBecVmTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VM_PREFIX, TEMPLATE, CREATE);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVmTemplateResponse.class);
    }

    public GetBecVmTemplateListResponse listBecVmTemplate(GetBecVmTemplateListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, TEMPLATE, LIST);
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeywordType())) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (request.getPageNo() != 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() != 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBecVmTemplateListResponse.class);
    }

    public GetBecVmTemplateResponse getBecVmTemplate(GetBecVmTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getTemplateId(), StringFormatUtils.checkEmptyExceptionMessageFormat(TEMPLATE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, TEMPLATE, request.getTemplateId());
        return this.invokeHttpClient(internalRequest, GetBecVmTemplateResponse.class);
    }

    public CreateBecBlbResponse createBecBlb(CreateBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbResponse.class);
    }

    public GetBecBlbsResponse getBecBlbs(GetBecBlbsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getLbType())) {
            internalRequest.addParameter("lbType", request.getLbType());
        }
        if (request.getLbType() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getLbType() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbsResponse.class);
    }

    public GetBecBlbInstanceResponse getBecBlb(GetBecBlbInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId());
        return this.invokeHttpClient(internalRequest, GetBecBlbInstanceResponse.class);
    }

    public DeleteBecBlbResponse deleteBecBlb(DeleteBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, BLB_PREFIX, request.getBlbId());
        return this.invokeHttpClient(internalRequest, DeleteBecBlbResponse.class);
    }

    public UpdateBecBlbResponse updateBecBlb(UpdateBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbResponse.class);
    }

    public CreateBecBlbMonitorPortResponse createBecBlbMonitorPort(CreateBecBlbMonitorPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX, request.getBlbId(), MONITOR);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbMonitorPortResponse.class);
    }

    public GetBecBlbMonitorPortListResponse getBlbMonitorPortList(GetBecBlbMonitorPortListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), MONITOR);
        return this.invokeHttpClient(internalRequest, GetBecBlbMonitorPortListResponse.class);
    }

    public GetBecBlbMonitorPortDetailsResponse getBecBlbMonitorPortDetails(GetBecBlbMonitorPortDetailsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), MONITOR, PORT);
        if (request.getProtocol() != null) {
            internalRequest.addParameter("protocol", String.valueOf((Object)request.getProtocol()));
        }
        if (request.getPort() != 0) {
            internalRequest.addParameter(PORT, String.valueOf(request.getPort()));
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbMonitorPortDetailsResponse.class);
    }

    public UpdateBecBlbMonitorPortResponse updateBecBlbMonitorPort(UpdateBecBlbMonitorPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId(), MONITOR);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbMonitorPortResponse.class);
    }

    public GetBecBlbBackendPodListResponse getBecBlbBackendPodList(GetBecBlbBackendPodListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDED);
        return this.invokeHttpClient(internalRequest, GetBecBlbBackendPodListResponse.class);
    }

    public GetBecBlbBackendBindingStsListResponse getBecBlbBackendBindingStsList(GetBecBlbBackendBindingStsListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDING);
        return this.invokeHttpClient(internalRequest, GetBecBlbBackendBindingStsListResponse.class);
    }

    public GetBecBlbBindingPodListWithStsResponse getBecBlbBindingPodListWithSts(GetBecBlbBindingPodListWithStsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDINGPOD);
        if (StringUtils.isNotEmpty((CharSequence)request.getStsName())) {
            internalRequest.addParameter("stsName", request.getStsName());
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbBindingPodListWithStsResponse.class);
    }

    public CreateBecBlbBindingResponse createBecBlbBinding(CreateBecBlbBindingRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX, request.getBlbId(), BINDING);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbBindingResponse.class);
    }

    public UpdateBecBlbBindPodWeightResponse updateBecBlbBindPodWeight(UpdateBecBlbBindPodWeightRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId(), BINDED);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbBindPodWeightResponse.class);
    }

    public GetBecBlbResourceMetricsResponse getBecBlbResourceMetrics(GetBecBlbResourceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)request.getStart(), (Object)START_MESSAGE_KEY);
        Preconditions.checkNotNull((Object)request.getEnd(), (Object)END_MESSAGE_KEY);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, LB_PREFIX, request.getBlbId());
        if (StringUtils.isNotEmpty((CharSequence)request.getMetricsType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getMetricsType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getIpType())) {
            internalRequest.addParameter(IP_TYPE_MESSAGE_KEY, request.getIpType());
        }
        if (request.getStart() > 0L && request.getEnd() > 0L) {
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(request.getStart()));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(request.getEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPort())) {
            internalRequest.addParameter(PORT, request.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbResourceMetricsResponse.class);
    }

    public GetBecResourceSummaryResponse getBecResourceSummary(GetBecResourceSummaryRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY);
        if (StringUtils.isNotEmpty((CharSequence)request.getRegion())) {
            internalRequest.addParameter(VM_INSTANCE_REGION_MESSAGE_KEY, request.getRegion());
        }
        return this.invokeHttpClient(internalRequest, GetBecResourceSummaryResponse.class);
    }

    public GetBecContainerSummaryResponse getBecContainerSummary(GetBecContainerSummaryRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY, CONTAINER);
        return this.invokeHttpClient(internalRequest, GetBecContainerSummaryResponse.class);
    }

    public GetBecVMSummaryResponse getBecVmSummary(GetBecVMSummaryRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY, VM_PREFIX);
        return this.invokeHttpClient(internalRequest, GetBecVMSummaryResponse.class);
    }

    public GetBecContainerMetricsResponse getBecContainerMetrics(GetBecContainerMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, OVERVIEW, CONTAINER, request.getType());
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() != null && request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(start));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        if (request.getStepInMin() != null && request.getStepInMin() > 0) {
            internalRequest.addParameter("stepInMin", String.valueOf(request.getStepInMin()));
        }
        return this.invokeHttpClient(internalRequest, GetBecContainerMetricsResponse.class);
    }

    public GetBecVmMetricsResponse getBecVmMetrics(GetBecVmMetricsRequest request) {
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, OVERVIEW, VM_PREFIX, request.getType());
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() != null && request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(start));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        if (request.getStepInMin() != null && request.getStepInMin() > 0) {
            internalRequest.addParameter("stepInMin", String.valueOf(request.getStepInMin()));
        }
        return this.invokeHttpClient(internalRequest, GetBecVmMetricsResponse.class);
    }

    public ListBecServicePackagesResponse listBecServicePackages(ListBecServicePackagesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, RESOURCE, PACKAGE, request.getType());
        return this.invokeHttpClient(internalRequest, ListBecServicePackagesResponse.class);
    }

    public ListBecPassThroughDiskPackagesResponse listBecPassThroughDiskPackages(ListBecPassThroughDiskPackagesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, RESOURCE, DISK, PASS_THROUGH);
        return this.invokeHttpClient(internalRequest, ListBecPassThroughDiskPackagesResponse.class);
    }

    public CreateBecVmImageResponse createBecVmImage(CreateBecVmImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VM_PREFIX, IMAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVmImageResponse.class);
    }

    public GetBecVmImagesResponse getBecVmImages(GetBecVmImagesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, IMAGE);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrder())) {
                internalRequest.addParameter("order", request.getListRequest().getOrder());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrderBy())) {
                internalRequest.addParameter("orderBy", request.getListRequest().getOrderBy());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(BLB_TYPE_MESSAGE_KEY, request.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getImageId())) {
            internalRequest.addParameter(IMAGE_ID_MESSAGE_KEY, request.getImageId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOsName())) {
            internalRequest.addParameter("osName", request.getOsName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegionId())) {
            internalRequest.addParameter("regionId", request.getRegionId());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmImagesResponse.class);
    }

    public UpdateBecVmImageResponse updateBecVmImage(UpdateBecVmImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, IMAGE, request.getImageId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVmImageResponse.class);
    }

    public BatchDeleteBecVmImageResponse batchDeleteBecVmImage(BatchDeleteBecVmImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkMultyParamsNotBothEmpty(request.getImageIdList(), IMAGE_ID_LIST_MESSAGE_KEY);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VM_PREFIX, IMAGE);
        String imageIdList = String.join((CharSequence)",", request.getImageIdList());
        internalRequest.addParameter(IMAGE_ID_LIST_MESSAGE_KEY, imageIdList);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecVmImageResponse.class);
    }

    public CreateBecDeploySetResponse createBecDeploySet(CreateBecDeploySetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEPLOY_SET_PREFIX, CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecDeploySetResponse.class);
    }

    public GetBecDeploySetsResponse getBecDeploySets(GetBecDeploySetsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEPLOY_SET_PREFIX, LIST);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecDeploySetsResponse.class);
    }

    public GetBecDeploySetResponse getBecDeploySet(GetBecDeploySetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDeploySetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DEPLOY_SET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEPLOY_SET_PREFIX, request.getDeploySetId());
        return this.invokeHttpClient(internalRequest, GetBecDeploySetResponse.class);
    }

    public UpdateBecDeploySetResponse updateBecDeploySet(UpdateBecDeploySetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDeploySetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DEPLOY_SET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEPLOY_SET_PREFIX, request.getDeploySetId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        internalRequest.addParameter("modifyAttribute", "");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecDeploySetResponse.class);
    }

    public DeleteBecDeploySetResponse deleteBecDeploySet(DeleteBecDeploySetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDeploySetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DEPLOY_SET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, DEPLOY_SET_PREFIX, request.getDeploySetId());
        return this.invokeHttpClient(internalRequest, DeleteBecDeploySetResponse.class);
    }

    public DeleteBecDeploySetInstancesResponse deleteBecDeploySetInstances(DeleteBecDeploySetInstancesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDeploysetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DEPLOY_SET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEPLOY_SET_PREFIX, DEL_RELATION);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecDeploySetInstancesResponse.class);
    }

    public UpdateBecDeploySetInstanceResponse updateBecDeploySetInstance(UpdateBecDeploySetInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEPLOY_SET_PREFIX, UPDATE_RELATION);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecDeploySetInstanceResponse.class);
    }

    public CreateBecVpcResponse createBecVpc(CreateBecVpcRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVpcResponse.class);
    }

    public GetBecVpcResponse getBecVpc(GetBecVpcRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVpcId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VPC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, request.getVpcId());
        return this.invokeHttpClient(internalRequest, GetBecVpcResponse.class);
    }

    public GetBecVpcsResponse getBecVpcs(GetBecVpcsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegionId())) {
            internalRequest.addParameter("regionId", request.getRegionId());
        }
        return this.invokeHttpClient(internalRequest, GetBecVpcsResponse.class);
    }

    public UpdateBecVpcResponse updateBecVpc(UpdateBecVpcRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVpcId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VPC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VPC_PREFIX, request.getVpcId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVpcResponse.class);
    }

    public DeleteBecVpcResponse deleteBecVpc(DeleteBecVpcRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVpcId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VPC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VPC_PREFIX, request.getVpcId());
        return this.invokeHttpClient(internalRequest, DeleteBecVpcResponse.class);
    }

    public CreateBecSubnetResponse createBecSubnet(CreateBecSubnetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC_PREFIX, SUBNET_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecSubnetResponse.class);
    }

    public GetBecSubnetResponse getBecSubnet(GetBecSubnetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSubnetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SUBNET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, SUBNET_PREFIX, request.getSubnetId());
        return this.invokeHttpClient(internalRequest, GetBecSubnetResponse.class);
    }

    public GetBecSubnetsResponse getBecSubnets(GetBecSubnetsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, SUBNET_PREFIX);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, GetBecSubnetsResponse.class);
    }

    public UpdateBecSubnetResponse updateBecSubnet(UpdateBecSubnetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSubnetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SUBNET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VPC_PREFIX, SUBNET_PREFIX, request.getSubnetId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecSubnetResponse.class);
    }

    public DeleteBecSubnetResponse deleteBecSubnet(DeleteBecSubnetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSubnetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SUBNET_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VPC_PREFIX, SUBNET_PREFIX, request.getSubnetId());
        return this.invokeHttpClient(internalRequest, DeleteBecSubnetResponse.class);
    }

    public CreateBecSecurityGroupResponse createBecSecurityGroup(CreateBecSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SECURITY_GROUP_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecSecurityGroupResponse.class);
    }

    public BatchCreateBecSgRulesResponse batchCreateBecSecurityGroupRules(BatchCreateBecSgRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SECURITY_GROUP_PREFIX, request.getSecurityGroupId(), RULE, BATCH, ADD);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchCreateBecSgRulesResponse.class);
    }

    public GetBecSecurityGroupResponse getBecSecurityGroup(GetBecSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SECURITY_GROUP_PREFIX, request.getSecurityGroupId());
        return this.invokeHttpClient(internalRequest, GetBecSecurityGroupResponse.class);
    }

    public GetBecSecurityGroupsResponse getBecSecurityGroups(GetBecSecurityGroupsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SECURITY_GROUP_PREFIX);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecSecurityGroupsResponse.class);
    }

    public UpdateBecSecurityGroupResponse updateBecSecurityGroup(UpdateBecSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITY_GROUP_PREFIX, request.getSecurityGroupId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecSecurityGroupResponse.class);
    }

    public UpdateBecSecurityGroupRuleResponse updateBecSecurityGroupRule(UpdateBecSecurityGroupRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSecurityGroupRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_RULE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITY_GROUP_PREFIX, request.getSecurityGroupId(), RULE, request.getSecurityGroupRuleId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecSecurityGroupRuleResponse.class);
    }

    public DeleteBecSecurityGroupResponse deleteBecSecurityGroup(DeleteBecSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, SECURITY_GROUP_PREFIX, request.getSecurityGroupId());
        return this.invokeHttpClient(internalRequest, DeleteBecSecurityGroupResponse.class);
    }

    public BatchDeleteBecSgRulesResponse batchDeleteBecSecurityGroupRules(BatchDeleteBecSgRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITY_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SECURITY_GROUP_PREFIX, request.getSecurityGroupId(), RULE, BATCH, DELETE);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecSgRulesResponse.class);
    }

    public CreateBecRouteRuleResponse createBecRouteRule(CreateBecRouteRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ROUTE_PREFIX, RULE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecRouteRuleResponse.class);
    }

    public GetBecRouteTableResponse getBecRouteTable(GetBecRouteTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getTableId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ROUTE_TABLE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ROUTE_PREFIX, DETAIL, request.getTableId());
        return this.invokeHttpClient(internalRequest, GetBecRouteTableResponse.class);
    }

    public GetBecRouteTablesResponse getBecRouteTables(GetBecRouteTablesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ROUTE_PREFIX, LIST);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegionId())) {
            internalRequest.addParameter("regionId", request.getRegionId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, GetBecRouteTablesResponse.class);
    }

    public GetBecRouteRulesResponse getBecRouteRules(GetBecRouteRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getTableId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ROUTE_TABLE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ROUTE_PREFIX, RULE, LIST, request.getTableId());
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTableId())) {
            internalRequest.addParameter(ROUTE_TABLE_ID_MESSAGE_KEY, request.getTableId());
        }
        return this.invokeHttpClient(internalRequest, GetBecRouteRulesResponse.class);
    }

    public UpdateBecRouteTableResponse updateBecRouteTable(UpdateBecRouteTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getTableId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ROUTE_TABLE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ROUTE_PREFIX, UPDATE, request.getTableId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecRouteTableResponse.class);
    }

    public DeleteBecRouteRuleResponse deleteBecRouteRule(DeleteBecRouteRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat("ruleId"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ROUTE_PREFIX, RULE, DELETE, request.getRuleId());
        return this.invokeHttpClient(internalRequest, DeleteBecRouteRuleResponse.class);
    }

    public BatchCreateBecAclRulesResponse batchCreateBecAclRules(BatchCreateBecAclRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC_PREFIX, ACL, RULE, BATCH, CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchCreateBecAclRulesResponse.class);
    }

    public GetBecAclResponse getBecAcl(GetBecAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVpcId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VPC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, ACL, DETAIL);
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, GetBecAclResponse.class);
    }

    public GetBecAclsResponse getBecAcls(GetBecAclsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VPC_PREFIX, ACL, LIST);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegionId())) {
            internalRequest.addParameter("regionId", request.getRegionId());
        }
        return this.invokeHttpClient(internalRequest, GetBecAclsResponse.class);
    }

    public UpdateBecAclResponse updateBecAcl(UpdateBecAclRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAclId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACL_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VPC_PREFIX, ACL, request.getAclId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAclResponse.class);
    }

    public UpdateBecAclRuleResponse updateBecAclRule(UpdateBecAclRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAclRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACL_RULE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VPC_PREFIX, ACL, RULE, request.getAclRuleId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAclRuleResponse.class);
    }

    public BatchDeleteBecAclRulesResponse batchDeleteBecAclRules(BatchDeleteBecAclRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC_PREFIX, ACL, RULE, BATCH, DELETE);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecAclRulesResponse.class);
    }

    public CreateBecAppBlbResponse createBecAppBlbV2(CreateBecAppBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbResponse.class);
    }

    public GetBecAppBlbResponse getBecAppBlbV2(GetBecAppBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId());
        return this.invokeHttpClient(internalRequest, GetBecAppBlbResponse.class);
    }

    public GetBecAppBlbsResponse getBecAppBlbsV2(GetBecAppBlbsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbsResponse.class);
    }

    public UpdateBecAppBlbResponse updateBecAppBlbV2(UpdateBecAppBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbResponse.class);
    }

    public DeleteBecAppBlbResponse deleteBecAppBlbV2(DeleteBecAppBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.DELETE, APP_BLB_PREFIX, request.getBlbId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbResponse.class);
    }

    public CreateBecAppBlbTCPListenerResponse createBecAppBlbTCPListenerV2(CreateBecAppBlbTCPListenerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), TCP_LISTENER);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbTCPListenerResponse.class);
    }

    public CreateBecAppBlbUDPListenerResponse createBecAppBlbUDPListenerV2(CreateBecAppBlbUDPListenerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), UDP_LISTENER);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbUDPListenerResponse.class);
    }

    public CreateBecAppBlbListenerPoliciesResponse createBecAppBlbListenerPoliciesV2(CreateBecAppBlbListenerPoliciesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), POLICYS);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbListenerPoliciesResponse.class);
    }

    public GetBecAppBlbTCPListenersResponse getBecAppBlbTCPListenersV2(GetBecAppBlbTCPListenersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), TCP_LISTENER);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListenerPort()})) {
            internalRequest.addParameter("listenerPort", String.valueOf(request.getListenerPort()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbTCPListenersResponse.class);
    }

    public GetBecAppBlbUDPListenersResponse getBecAppBlbUDPListenersV2(GetBecAppBlbUDPListenersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), UDP_LISTENER);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListenerPort()})) {
            internalRequest.addParameter("listenerPort", String.valueOf(request.getListenerPort()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbUDPListenersResponse.class);
    }

    public GetBecAppBlbListenerPoliciesResponse getBecAppBlbListenerPoliciesV2(GetBecAppBlbListenerPoliciesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), POLICYS);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getPort()})) {
            internalRequest.addParameter(PORT, String.valueOf(request.getPort()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getType()})) {
            internalRequest.addParameter(BLB_TYPE_MESSAGE_KEY, String.valueOf(request.getType()));
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbListenerPoliciesResponse.class);
    }

    public UpdateBecAppBlbTCPListenerResponse updateBecAppBlbTCPListenerV2(UpdateBecAppBlbTCPListenerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), TCP_LISTENER);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListenerPort()})) {
            internalRequest.addParameter("listenerPort", String.valueOf(request.getListenerPort()));
        }
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbTCPListenerResponse.class);
    }

    public UpdateBecAppBlbUDPListenerResponse updateBecAppBlbUDPListenerV2(UpdateBecAppBlbUDPListenerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), UDP_LISTENER);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListenerPort()})) {
            internalRequest.addParameter("listenerPort", String.valueOf(request.getListenerPort()));
        }
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbUDPListenerResponse.class);
    }

    public DeleteBecAppBlbListenerPoliciesResponse deleteBecAppBlbListenerPoliciesV2(DeleteBecAppBlbListenerPoliciesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), POLICYS);
        internalRequest.addParameter(BATCH_DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbListenerPoliciesResponse.class);
    }

    public BatchDeleteBecAppBlbListenersResponse batchDeleteBecAppBlbListenersV2(BatchDeleteBecAppBlbListenersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), LISTENER);
        internalRequest.addParameter(BATCH_DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecAppBlbListenersResponse.class);
    }

    public CreateBecAppBlbIpGroupResponse createBecAppBlbIpGroupV2(CreateBecAppBlbIpGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbIpGroupResponse.class);
    }

    public CreateBecAppBlbIpGroupBackendPolicyResponse createBecAppBlbIpGroupBackendPoliciesV2(CreateBecAppBlbIpGroupBackendPolicyRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, BACKEND_POLICY);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbIpGroupBackendPolicyResponse.class);
    }

    public CreateBecAppBlbIpGroupMembersResponse createBecAppBlbIpGroupMembersV2(CreateBecAppBlbIpGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, MEMBER);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbIpGroupMembersResponse.class);
    }

    public GetBecAppBlbIpGroupsResponse getBecAppBlbIpGroupsV2(GetBecAppBlbIpGroupsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getExactlyMatch()})) {
            internalRequest.addParameter(EXACTLY_MATCH, String.valueOf(request.getExactlyMatch()));
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbIpGroupsResponse.class);
    }

    public GetBecAppBlbIpGroupBackendPoliciesResponse getBecAppBlbIpGroupPoliciesV2(GetBecAppBlbIpGroupBackendPoliciesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, BACKEND_POLICY);
        internalRequest.addParameter(IP_GROUP_ID_MESSAGE_KEY, request.getIpGroupId());
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbIpGroupBackendPoliciesResponse.class);
    }

    public GetBecAppBlbIpGroupMembersResponse getBecAppBlbIpGroupMembersV2(GetBecAppBlbIpGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, MEMBER);
        internalRequest.addParameter(IP_GROUP_ID_MESSAGE_KEY, request.getIpGroupId());
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbIpGroupMembersResponse.class);
    }

    public UpdateBecAppBlbIpGroupResponse updateBecAppBlbIpGroupV2(UpdateBecAppBlbIpGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbIpGroupResponse.class);
    }

    public UpdateBecAppBlbIpGroupBackendPolicyResponse updateBecAppBlbIpGroupPolicyV2(UpdateBecAppBlbIpGroupBackendPolicyRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, BACKEND_POLICY);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbIpGroupBackendPolicyResponse.class);
    }

    public UpdateBecAppBlbIpGroupMembersResponse updateBecAppBlbIpGroupMembersV2(UpdateBecAppBlbIpGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, MEMBER);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbIpGroupMembersResponse.class);
    }

    public DeleteBecAppBlbIpGroupResponse deleteBecAppBlbIpGroupV2(DeleteBecAppBlbIpGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP);
        internalRequest.addParameter(DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbIpGroupResponse.class);
    }

    public DeleteBecAppBlbIpGroupBackendPoliciesResponse deleteBecAppBlbIpGroupBackendPoliciesV2(DeleteBecAppBlbIpGroupBackendPoliciesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, BACKEND_POLICY);
        internalRequest.addParameter(DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbIpGroupBackendPoliciesResponse.class);
    }

    public DeleteBecAppBlbIpGroupMembersResponse deleteBecAppBlbIpGroupMembersV2(DeleteBecAppBlbIpGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), IP_GROUP, MEMBER);
        internalRequest.addParameter(DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbIpGroupMembersResponse.class);
    }

    public CreateBecAppBlbServerGroupResponse createBecAppBlbServerGroupV2(CreateBecAppBlbServerGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbServerGroupResponse.class);
    }

    public UpdateBecAppBlbServerGroupResponse updateBecAppBlbServerGroupV2(UpdateBecAppBlbServerGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbServerGroupResponse.class);
    }

    public GetBecAppBlbServerGroupsResponse getBecAppBlbServerGroupsV2(GetBecAppBlbServerGroupsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (request.getExactlyMatch() != null) {
            internalRequest.addParameter(EXACTLY_MATCH, String.valueOf(request.getExactlyMatch()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbServerGroupsResponse.class);
    }

    public DeleteBecAppBlbServerGroupResponse deleteBecAppBlbServerGroupV2(DeleteBecAppBlbServerGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP);
        internalRequest.addParameter(DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbServerGroupResponse.class);
    }

    public CreateBecAppBlbServerGroupPortResponse createBecAppBlbServerGroupPortV2(CreateBecAppBlbServerGroupPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP_PORT);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbServerGroupPortResponse.class);
    }

    public UpdateBecAppBlbServerGroupPortResponse updateBecAppBlbServerGroupPortV2(UpdateBecAppBlbServerGroupPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP_PORT);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbServerGroupPortResponse.class);
    }

    public DeleteBecAppBlbServerGroupPortResponse deleteBecAppBlbServerGroupPortV2(DeleteBecAppBlbServerGroupPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), APP_SERVER_GROUP_PORT);
        internalRequest.addParameter(DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbServerGroupPortResponse.class);
    }

    public CreateBecAppBlbServerGroupMemberResponse createBecAppBlbServerGroupMemberV2(CreateBecAppBlbServerGroupMemberRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.POST, APP_BLB_PREFIX, request.getBlbId(), BLBRS);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecAppBlbServerGroupMemberResponse.class);
    }

    public GetBecAppBlbServerGroupMembersResponse getBecAppBlbServerGroupMembersV2(GetBecAppBlbServerGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSgId(), StringFormatUtils.checkEmptyExceptionMessageFormat("sgId"));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), BLBRS);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSgId())) {
            internalRequest.addParameter("sgId", request.getSgId());
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbServerGroupMembersResponse.class);
    }

    public GetBecAppBlbServerGroupUnmountedMembersResponse getBecAppBlbServerGroupUnboundMembersV2(GetBecAppBlbServerGroupUnmountedMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSgId(), StringFormatUtils.checkEmptyExceptionMessageFormat("sgId"));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), BLBRSUNMOUNT);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSgId())) {
            internalRequest.addParameter("sgId", request.getSgId());
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbServerGroupUnmountedMembersResponse.class);
    }

    public GetBecAppBlbServerGroupMountedMembersResponse getBecAppBlbServerGroupMountedMembersV2(GetBecAppBlbServerGroupMountedMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSgId(), StringFormatUtils.checkEmptyExceptionMessageFormat("sgId"));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.GET, APP_BLB_PREFIX, request.getBlbId(), BLBRSMOUNT);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getMarker())) {
                internalRequest.addParameter(MARKER, request.getListRequest().getMarker());
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest().getMaxKeys()})) {
                internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getListRequest().getMaxKeys()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSgId())) {
            internalRequest.addParameter("sgId", request.getSgId());
        }
        return this.invokeHttpClient(internalRequest, GetBecAppBlbServerGroupMountedMembersResponse.class);
    }

    public UpdateBecAppBlbServerGroupMembersResponse updateBecAppBlbServerGroupMembersV2(UpdateBecAppBlbServerGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), BLBRS);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecAppBlbServerGroupMembersResponse.class);
    }

    public DeleteBecAppBlbServerGroupMembersResponse deleteBecAppBlbServerGroupMembersV2(DeleteBecAppBlbServerGroupMembersRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestV2(request, HttpMethodName.PUT, APP_BLB_PREFIX, request.getBlbId(), BLBRS);
        internalRequest.addParameter(BATCH_DELETE, "");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DeleteBecAppBlbServerGroupMembersResponse.class);
    }

    public BatchCreateBecNatsResponse batchCreateBecNat(BatchCreateBecNatsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, BATCH, CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchCreateBecNatsResponse.class);
    }

    public GetBecNatResponse getBecNat(GetBecNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId());
        return this.invokeHttpClient(internalRequest, GetBecNatResponse.class);
    }

    public GetBecNatsResponse getBecNats(GetBecNatsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, LIST);
        if (ObjectUtils.allNotNull((Object[])new Object[]{request.getListRequest()})) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegionId())) {
            internalRequest.addParameter("regionId", request.getRegionId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, GetBecNatsResponse.class);
    }

    public UpdateBecNatResponse updateBecNat(UpdateBecNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), UPDATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecNatResponse.class);
    }

    public UpdateBecNatBandwidthResponse updateBecNatBandwidth(UpdateBecNatBandwidthRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), UPDATE_BANDWIDTH);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecNatBandwidthResponse.class);
    }

    public BatchDeleteBecNatsResponse batchDeleteBecNats(BatchDeleteBecNatsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, BATCH, DELETE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecNatsResponse.class);
    }

    public GetBecNatMetricsResponse getBecNatMetrics(GetBecNatMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getMetricsType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)request.getStart(), (Object)START_MESSAGE_KEY);
        Preconditions.checkNotNull((Object)request.getEnd(), (Object)END_MESSAGE_KEY);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, NAT_PREFIX, request.getNatId());
        if (request.getStart() > 0L && request.getEnd() > 0L) {
            internalRequest.addParameter(START_MESSAGE_KEY, String.valueOf(request.getStart()));
            internalRequest.addParameter(END_MESSAGE_KEY, String.valueOf(request.getEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getMetricsType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getMetricsType());
        }
        return this.invokeHttpClient(internalRequest, GetBecNatMetricsResponse.class);
    }

    public CreateBecSnatRuleResponse createBecSnatRule(CreateBecSnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), SNAT_RULE, CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecSnatRuleResponse.class);
    }

    public BatchCreateBecSnatRulesResponse batchCreateBecSnatRules(BatchCreateBecSnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), SNAT_RULE, BATCH_CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchCreateBecSnatRulesResponse.class);
    }

    public GetBecSnatRulesResponse getBecSnatRules(GetBecSnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId(), SNAT_RULE);
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBecSnatRulesResponse.class);
    }

    public UpdateBecSnatRuleResponse updateBecSnatRule(UpdateBecSnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), SNAT_RULE, request.getRuleId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecSnatRuleResponse.class);
    }

    public BatchDeleteBecSnatRulesResponse batchDeleteBecSnatRules(BatchDeleteBecSnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), SNAT_RULE, BATCH, DELETE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecSnatRulesResponse.class);
    }

    public CreateBecDnatRuleResponse createBecDnatRule(CreateBecDnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), DNAT_RULE, CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecDnatRuleResponse.class);
    }

    public BatchCreateBecDnatRulesResponse batchCreateBecDnatRules(BatchCreateBecDnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), DNAT_RULE, BATCH_CREATE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchCreateBecDnatRulesResponse.class);
    }

    public GetBecDnatRulesResponse getBecDnatRules(GetBecDnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId(), DNAT_RULE);
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBecDnatRulesResponse.class);
    }

    public UpdateBecDnatRuleResponse updateBecDnatRule(UpdateBecDnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat("ruleId"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), DNAT_RULE, request.getRuleId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecDnatRuleResponse.class);
    }

    public BatchDeleteBecDnatRulesResponse batchDeleteBecDnatRules(BatchDeleteBecDnatRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getNatId(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), DNAT_RULE, BATCH, DELETE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BatchDeleteBecDnatRulesResponse.class);
    }
}

